/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.inject.Inject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.render.HtmlRenderer;
import org.apache.shindig.gadgets.render.RenderingException;
import org.apache.shindig.gadgets.render.RenderingResults;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;

public class Renderer {
    private static final String classname = Renderer.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final Processor processor;
    private final HtmlRenderer renderer;
    private final ContainerConfig containerConfig;
    private final LockedDomainService lockedDomainService;

    @Inject
    public Renderer(Processor processor, HtmlRenderer renderer, ContainerConfig containerConfig, LockedDomainService lockedDomainService) {
        this.processor = processor;
        this.renderer = renderer;
        this.containerConfig = containerConfig;
        this.lockedDomainService = lockedDomainService;
    }

    public RenderingResults render(GadgetContext context) {
        if (!this.validateParent(context)) {
            return RenderingResults.error("Unsupported parent parameter. Check your container code.", 400);
        }
        try {
            Gadget gadget = this.processor.process(context);
            GadgetSpec gadgetSpec = gadget.getSpec();
            if (gadget.getCurrentView() == null) {
                return RenderingResults.error("Unable to locate an appropriate view in this gadget. Requested: '" + gadget.getContext().getView() + "' Available: " + gadgetSpec.getViews().keySet(), 404);
            }
            if (gadget.getCurrentView().getType() == View.ContentType.URL) {
                if (gadget.requiresCaja()) {
                    return RenderingResults.error("Caja does not support url type gadgets.", 400);
                }
                if (gadget.sanitizeOutput()) {
                    return RenderingResults.error("Type=url gadgets cannot be sanitized.", 400);
                }
                return RenderingResults.mustRedirect(gadget.getCurrentView().getHref());
            }
            if (!this.lockedDomainService.isGadgetValidForHost(context.getHost(), gadget, context.getContainer())) {
                return RenderingResults.error("Invalid domain for host (" + context.getHost() + ") and gadget (" + gadgetSpec.getUrl() + ")", 400);
            }
            return RenderingResults.ok(this.renderer.render(gadget));
        }
        catch (RenderingException e) {
            return this.logError("render", context.getUrl(), e.getHttpStatusCode(), e);
        }
        catch (ProcessingException e) {
            return this.logError("render", context.getUrl(), e.getHttpStatusCode(), e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof GadgetException) {
                return this.logError("render", context.getUrl(), ((GadgetException)e.getCause()).getHttpStatusCode(), e.getCause());
            }
            throw e;
        }
    }

    private RenderingResults logError(String methodname, Uri gadgetUrl, int statusCode, Throwable t) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.logp(Level.INFO, classname, methodname, "FailedToRender", new Object[]{gadgetUrl, t.getMessage()});
        }
        return RenderingResults.error(t.getMessage(), statusCode);
    }

    private boolean validateParent(GadgetContext context) {
        String container = context.getContainer();
        String parent = context.getParameter("parent");
        if (parent == null) {
            return true;
        }
        List parents = this.containerConfig.getList(container, "gadgets.parent");
        if (parents.isEmpty()) {
            return true;
        }
        for (Object pattern : parents) {
            if (!Pattern.matches(pattern.toString(), parent)) continue;
            return true;
        }
        return false;
    }
}

