/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.render.CajaResponseRewriter;
import org.apache.shindig.gadgets.render.OpenSocialI18NGadgetRewriter;
import org.apache.shindig.gadgets.render.RenderingGadgetRewriter;
import org.apache.shindig.gadgets.render.SanitizingGadgetRewriter;
import org.apache.shindig.gadgets.render.SanitizingResponseRewriter;
import org.apache.shindig.gadgets.rewrite.AbsolutePathReferenceRewriter;
import org.apache.shindig.gadgets.rewrite.ContextAwareRegistry;
import org.apache.shindig.gadgets.rewrite.CssResponseRewriter;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.PipelineDataGadgetRewriter;
import org.apache.shindig.gadgets.rewrite.ProxyingContentRewriter;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterList;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritePath;
import org.apache.shindig.gadgets.rewrite.RewriterRegistry;
import org.apache.shindig.gadgets.rewrite.StyleAdjacencyContentRewriter;
import org.apache.shindig.gadgets.rewrite.StyleTagExtractorContentRewriter;
import org.apache.shindig.gadgets.rewrite.StyleTagProxyEmbeddedUrlsRewriter;
import org.apache.shindig.gadgets.rewrite.TemplateRewriter;
import org.apache.shindig.gadgets.rewrite.image.BasicImageRewriter;
import org.apache.shindig.gadgets.servlet.CajaContentRewriter;

public class RewriteModule
extends AbstractModule {
    public static final String ACCEL_CONTAINER = "accel";
    public static final String DEFAULT_CONTAINER = "default";
    protected MapBinder<RewritePath, List<ResponseRewriter>> mapbinder;

    protected void configure() {
        this.configureGadgetRewriters();
        this.provideResponseRewriters();
    }

    protected void provideResponseRewriters() {
        this.mapbinder = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<RewritePath>(){}, (TypeLiteral)new TypeLiteral<List<ResponseRewriter>>(){});
        Provider<List<ResponseRewriter>> accelRewriterList = this.getResponseRewriters(ACCEL_CONTAINER, ResponseRewriterList.RewriteFlow.ACCELERATE);
        Provider<List<ResponseRewriter>> requestPipelineRewriterList = this.getResponseRewriters(DEFAULT_CONTAINER, ResponseRewriterList.RewriteFlow.REQUEST_PIPELINE);
        this.addBindingForRewritePath(DEFAULT_CONTAINER, ResponseRewriterList.RewriteFlow.REQUEST_PIPELINE);
        this.addBindingForRewritePath(DEFAULT_CONTAINER, ResponseRewriterList.RewriteFlow.DEFAULT);
        this.addBindingForRewritePath(ACCEL_CONTAINER, ResponseRewriterList.RewriteFlow.ACCELERATE);
        this.addBindingForRewritePath(ACCEL_CONTAINER, ResponseRewriterList.RewriteFlow.REQUEST_PIPELINE, requestPipelineRewriterList);
        this.addBindingForRewritePath(ACCEL_CONTAINER, ResponseRewriterList.RewriteFlow.DEFAULT, accelRewriterList);
    }

    protected void addBindingForRewritePath(String container, ResponseRewriterList.RewriteFlow rewriteFlow, Provider<List<ResponseRewriter>> list) {
        RewritePath rewritePath = new RewritePath(container, rewriteFlow);
        this.mapbinder.addBinding((Object)rewritePath).toProvider(list);
    }

    protected void addBindingForRewritePath(String container, ResponseRewriterList.RewriteFlow rewriteFlow) {
        this.addBindingForRewritePath(container, rewriteFlow, (Provider<List<ResponseRewriter>>)this.binder().getProvider(this.getKey(container, rewriteFlow)));
    }

    protected Provider<List<ResponseRewriter>> getResponseRewriters(String container, ResponseRewriterList.RewriteFlow flow) {
        return this.binder().getProvider(this.getKey(container, flow));
    }

    protected Key<List<ResponseRewriter>> getKey(String container, ResponseRewriterList.RewriteFlow flow) {
        return Key.get((TypeLiteral)new TypeLiteral<List<ResponseRewriter>>(){}, (Annotation)new RewritePath(container, flow));
    }

    @Provides
    @Singleton
    @RewriterRegistry(rewriteFlow=ResponseRewriterList.RewriteFlow.DEFAULT)
    public ResponseRewriterRegistry provideDefaultList(GadgetHtmlParser parser, Provider<Map<RewritePath, Provider<List<ResponseRewriter>>>> rewritePathToRewriterList) {
        return new ContextAwareRegistry(parser, ResponseRewriterList.RewriteFlow.DEFAULT, rewritePathToRewriterList);
    }

    @Provides
    @Singleton
    @RewriterRegistry(rewriteFlow=ResponseRewriterList.RewriteFlow.REQUEST_PIPELINE)
    public ResponseRewriterRegistry provideRequestPipelineList(GadgetHtmlParser parser, Provider<Map<RewritePath, Provider<List<ResponseRewriter>>>> rewritePathToRewriterList) {
        return new ContextAwareRegistry(parser, ResponseRewriterList.RewriteFlow.REQUEST_PIPELINE, rewritePathToRewriterList);
    }

    @Provides
    @Singleton
    @RewriterRegistry(rewriteFlow=ResponseRewriterList.RewriteFlow.ACCELERATE)
    public ResponseRewriterRegistry provideAccelerateList(GadgetHtmlParser parser, Provider<Map<RewritePath, Provider<List<ResponseRewriter>>>> rewritePathToRewriterList) {
        return new ContextAwareRegistry(parser, ResponseRewriterList.RewriteFlow.ACCELERATE, rewritePathToRewriterList);
    }

    protected void configureGadgetRewriters() {
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), GadgetRewriter.class, (Annotation)Names.named((String)"shindig.rewriters.gadget.set"));
        multibinder.addBinding().to(PipelineDataGadgetRewriter.class);
        multibinder.addBinding().to(TemplateRewriter.class);
        multibinder.addBinding().to(AbsolutePathReferenceRewriter.class);
        multibinder.addBinding().to(StyleTagExtractorContentRewriter.class);
        multibinder.addBinding().to(StyleAdjacencyContentRewriter.class);
        multibinder.addBinding().to(ProxyingContentRewriter.class);
        multibinder.addBinding().to(CajaContentRewriter.class);
        multibinder.addBinding().to(SanitizingGadgetRewriter.class);
        multibinder.addBinding().to(RenderingGadgetRewriter.class);
        multibinder.addBinding().to(OpenSocialI18NGadgetRewriter.class);
    }

    @Provides
    @Singleton
    @Named(value="shindig.rewriters.gadget")
    protected List<GadgetRewriter> provideGadgetRewriters(@Named(value="shindig.rewriters.gadget.set") Set<GadgetRewriter> gadgetRewritersSet) {
        return ImmutableList.copyOf(gadgetRewritersSet);
    }

    @Provides
    @Singleton
    @Named(value="shindig.rewriters.accelerate")
    protected List<GadgetRewriter> provideAccelRewriters(ProxyingContentRewriter proxyingContentRewriter, CajaContentRewriter cajaRewriter) {
        return ImmutableList.of((Object)proxyingContentRewriter, (Object)cajaRewriter);
    }

    @Provides
    @Singleton
    @ResponseRewriterList(rewriteFlow=ResponseRewriterList.RewriteFlow.REQUEST_PIPELINE)
    protected List<ResponseRewriter> providePreCacheResponseRewriters(BasicImageRewriter imageRewriter) {
        return ImmutableList.of((Object)imageRewriter);
    }

    @Provides
    @Singleton
    @ResponseRewriterList(rewriteFlow=ResponseRewriterList.RewriteFlow.DEFAULT)
    protected List<ResponseRewriter> provideDefaultRewriters(AbsolutePathReferenceRewriter absolutePathRewriter, StyleTagExtractorContentRewriter styleTagExtractorRewriter, StyleAdjacencyContentRewriter styleAdjacencyRewriter, ProxyingContentRewriter proxyingRewriter, CssResponseRewriter cssRewriter, SanitizingResponseRewriter sanitizedRewriter, CajaResponseRewriter cajaRewriter) {
        return ImmutableList.of((Object)absolutePathRewriter, (Object)styleTagExtractorRewriter, (Object)styleAdjacencyRewriter, (Object)proxyingRewriter, (Object)cssRewriter, (Object)sanitizedRewriter, (Object)cajaRewriter);
    }

    @Provides
    @Singleton
    @ResponseRewriterList(rewriteFlow=ResponseRewriterList.RewriteFlow.ACCELERATE, container="accel")
    protected List<ResponseRewriter> provideAccelResponseRewriters(AbsolutePathReferenceRewriter absolutePathReferenceRewriter, StyleTagProxyEmbeddedUrlsRewriter styleTagProxyEmbeddedUrlsRewriter, ProxyingContentRewriter proxyingContentRewriter) {
        return ImmutableList.of((Object)absolutePathReferenceRewriter, (Object)styleTagProxyEmbeddedUrlsRewriter, (Object)proxyingContentRewriter);
    }
}

