/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterList;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.servlet.ServletUtil;
import org.apache.shindig.gadgets.uri.AccelUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriUtils;

@Singleton
public class AccelHandler {
    private static final Logger logger = Logger.getLogger(AccelHandler.class.getName());
    static final String ERROR_FETCHING_DATA = "Error fetching data";
    protected final RequestPipeline requestPipeline;
    protected final ResponseRewriterRegistry contentRewriterRegistry;
    protected final AccelUriManager uriManager;
    protected final boolean remapInternalServerError;

    @Inject
    public AccelHandler(RequestPipeline requestPipeline, @RewriterRegistry(rewriteFlow=ResponseRewriterList.RewriteFlow.ACCELERATE) ResponseRewriterRegistry contentRewriterRegistry, AccelUriManager accelUriManager, @Named(value="shindig.accelerate.remapInternalServerError") Boolean remapInternalServerError) {
        this.requestPipeline = requestPipeline;
        this.contentRewriterRegistry = contentRewriterRegistry;
        this.uriManager = accelUriManager;
        this.remapInternalServerError = remapInternalServerError;
    }

    public HttpResponse fetch(HttpRequest request) throws IOException, GadgetException {
        ProxyUriManager.ProxyUri proxyUri = this.getProxyUri(request);
        HttpRequest req = this.buildHttpRequest(request, proxyUri);
        HttpResponse results = this.requestPipeline.execute(req);
        HttpResponse errorResponse = this.handleErrors(results);
        if (errorResponse == null) {
            try {
                results = this.contentRewriterRegistry.rewriteHttpResponse(req, results, null);
            }
            catch (RewritingException e) {
                logger.log(Level.WARNING, "Rewriting failed, serving original results", e);
            }
        } else {
            results = errorResponse;
        }
        HttpResponseBuilder response = new HttpResponseBuilder();
        UriUtils.copyResponseHeadersAndStatusCode(results, response, this.remapInternalServerError, false, UriUtils.DisallowedHeaders.OUTPUT_TRANSFER_DIRECTIVES, UriUtils.DisallowedHeaders.AUTHENTICATION_DIRECTIVES);
        UriUtils.maybeRewriteContentType(req, response);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)results.getResponse(), (OutputStream)baos);
        response.setResponseNoCopy(baos.toByteArray());
        return response.create();
    }

    public ProxyUriManager.ProxyUri getProxyUri(HttpRequest httpRequest) throws GadgetException {
        Uri requestedResource;
        Uri proxiedUri = this.uriManager.parseAndNormalize(httpRequest);
        String uriString = proxiedUri.getQueryParameter(UriCommon.Param.URL.getKey());
        try {
            requestedResource = Uri.parse((String)uriString);
        }
        catch (Uri.UriException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Failed to parse uri: " + uriString, 502);
        }
        Gadget gadget = DomWalker.makeGadget(httpRequest);
        ProxyUriManager.ProxyUri proxyUri = new ProxyUriManager.ProxyUri(gadget, requestedResource);
        proxyUri.setHtmlTagContext(proxiedUri.getQueryParameter(UriCommon.Param.HTML_TAG_CONTEXT.getKey()));
        return proxyUri;
    }

    protected HttpRequest buildHttpRequest(HttpRequest httpRequest, ProxyUriManager.ProxyUri uriToProxyOrRewrite) throws GadgetException {
        Uri tgt = uriToProxyOrRewrite.getResource();
        HttpRequest req = uriToProxyOrRewrite.makeHttpRequest(tgt);
        if (req == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "No url parameter in request", 400);
        }
        UriUtils.copyRequestData(httpRequest, req);
        ServletUtil.setXForwardedForHeader(httpRequest, req);
        UriUtils.copyRequestHeaders(httpRequest, req, UriUtils.DisallowedHeaders.POST_INCOMPATIBLE_DIRECTIVES, UriUtils.DisallowedHeaders.HOST_HEADER);
        req.setHeader("Host", tgt.getAuthority());
        req.setFollowRedirects(false);
        return req;
    }

    protected HttpResponse handleErrors(HttpResponse results) {
        if (results == null) {
            return new HttpResponseBuilder().setHttpStatusCode(404).setResponse(ERROR_FETCHING_DATA.getBytes()).create();
        }
        if (results.isError()) {
            return results;
        }
        return null;
    }
}

