/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.servlet.GadgetsHandlerApi;
import org.apache.shindig.gadgets.servlet.GadgetsHandlerService;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.protocol.BaseRequestItem;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.protocol.conversion.BeanDelegator;
import org.apache.shindig.protocol.conversion.BeanFilter;

@Service(name="gadgets")
public class GadgetsHandler {
    @VisibleForTesting
    static final String FAILURE_METADATA = "Failed to get gadget metadata.";
    @VisibleForTesting
    static final String FAILURE_TOKEN = "Failed to get gadget token.";
    @VisibleForTesting
    static final String FAILURE_PROXY = "Failed to get proxy data.";
    @VisibleForTesting
    static final String FAILURE_CAJA = "Failed to cajole data.";
    @VisibleForTesting
    static final String FAILURE_JS = "Failed to get js data.";
    private static final List<String> DEFAULT_METADATA_FIELDS = ImmutableList.of((Object)"iframeUrls", (Object)"userPrefs.*", (Object)"modulePrefs.*", (Object)"views.*");
    private static final List<String> DEFAULT_TOKEN_FIELDS = ImmutableList.of((Object)"token");
    private static final List<String> DEFAULT_PROXY_FIELDS = ImmutableList.of((Object)"proxyUrl");
    private static final List<String> DEFAULT_CAJA_FIELDS = ImmutableList.of((Object)"*");
    private static final List<String> DEFAULT_JS_FIELDS = ImmutableList.of((Object)"jsUrl");
    private static final Logger LOG = Logger.getLogger(GadgetsHandler.class.getName());
    protected final ExecutorService executor;
    protected final GadgetsHandlerService handlerService;
    protected final BeanFilter beanFilter;
    protected final BeanDelegator beanDelegator;

    @Inject
    public GadgetsHandler(ExecutorService executor, GadgetsHandlerService handlerService, BeanFilter beanFilter) {
        this.executor = executor;
        this.handlerService = handlerService;
        this.beanFilter = beanFilter;
        this.beanDelegator = new BeanDelegator();
    }

    @Operation(httpMethods={"POST", "GET"}, path="metadata")
    public Map<String, GadgetsHandlerApi.BaseResponse> metadata(BaseRequestItem request) throws ProtocolException {
        return new AbstractExecutor(){

            @Override
            protected Callable<CallableData> createJob(String url, BaseRequestItem request) throws ProcessingException {
                return GadgetsHandler.this.createMetadataJob(url, request);
            }
        }.execute(request);
    }

    @Operation(httpMethods={"POST", "GET"}, path="token")
    public Map<String, GadgetsHandlerApi.BaseResponse> token(BaseRequestItem request) throws ProtocolException {
        return new AbstractExecutor(){

            @Override
            protected Callable<CallableData> createJob(String url, BaseRequestItem request) throws ProcessingException {
                return GadgetsHandler.this.createTokenJob(url, request);
            }
        }.execute(request);
    }

    @Operation(httpMethods={"POST", "GET"}, path="js")
    public GadgetsHandlerApi.BaseResponse js(BaseRequestItem request) throws ProtocolException {
        GadgetsHandlerApi.BaseResponse response;
        try {
            JsRequestData jsRequest = new JsRequestData(request);
            response = this.handlerService.getJs(jsRequest);
        }
        catch (ProcessingException e) {
            response = this.handlerService.createErrorResponse(null, e.getHttpStatusCode(), e.getMessage());
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Error fetching JS", e);
            response = this.handlerService.createErrorResponse(null, 500, FAILURE_JS);
        }
        return response;
    }

    @Operation(httpMethods={"POST", "GET"}, path="proxy")
    public Map<String, GadgetsHandlerApi.BaseResponse> proxy(BaseRequestItem request) throws ProtocolException {
        return new AbstractExecutor(){

            @Override
            protected Callable<CallableData> createJob(String url, BaseRequestItem request) throws ProcessingException {
                return GadgetsHandler.this.createProxyJob(url, request);
            }
        }.execute(request);
    }

    @Operation(httpMethods={"POST", "GET"}, path="cajole")
    public Map<String, GadgetsHandlerApi.BaseResponse> cajole(BaseRequestItem request) throws ProtocolException {
        return new AbstractExecutor(){

            @Override
            protected Callable<CallableData> createJob(String url, BaseRequestItem request) throws ProcessingException {
                return GadgetsHandler.this.createCajaJob(url, request);
            }
        }.execute(request);
    }

    @Operation(httpMethods={"GET"}, path="/@metadata.supportedFields")
    public Set<String> supportedFields(RequestItem request) {
        return ImmutableSet.copyOf((Collection)this.beanFilter.getBeanFields(GadgetsHandlerApi.MetadataResponse.class, 5));
    }

    @Operation(httpMethods={"GET"}, path="/@token.supportedFields")
    public Set<String> tokenSupportedFields(RequestItem request) {
        return ImmutableSet.copyOf((Collection)this.beanFilter.getBeanFields(GadgetsHandlerApi.TokenResponse.class, 5));
    }

    @Operation(httpMethods={"GET"}, path="/@js.supportedFields")
    public Set<String> jsSupportedFields(RequestItem request) {
        return ImmutableSet.copyOf((Collection)this.beanFilter.getBeanFields(GadgetsHandlerApi.JsResponse.class, 5));
    }

    @Operation(httpMethods={"GET"}, path="/@proxy.supportedFields")
    public Set<String> proxySupportedFields(RequestItem request) {
        return ImmutableSet.copyOf((Collection)this.beanFilter.getBeanFields(GadgetsHandlerApi.ProxyResponse.class, 5));
    }

    @Operation(httpMethods={"GET"}, path="/@cajole.supportedFields")
    public Set<String> cajaSupportedFields(RequestItem request) {
        return ImmutableSet.copyOf((Collection)this.beanFilter.getBeanFields(GadgetsHandlerApi.CajaResponse.class, 5));
    }

    protected Callable<CallableData> createMetadataJob(final String url, BaseRequestItem request) throws ProcessingException {
        final MetadataRequestData metadataRequest = new MetadataRequestData(url, request);
        return new Callable<CallableData>(){

            @Override
            public CallableData call() throws Exception {
                try {
                    return new CallableData(url, GadgetsHandler.this.handlerService.getMetadata(metadataRequest));
                }
                catch (Exception e) {
                    return new CallableData(url, GadgetsHandler.this.handlerService.createErrorResponse(null, e, GadgetsHandler.FAILURE_METADATA));
                }
            }
        };
    }

    protected Callable<CallableData> createTokenJob(final String url, BaseRequestItem request) throws ProcessingException {
        final TokenRequestData tokenRequest = new TokenRequestData(url, request);
        return new Callable<CallableData>(){

            @Override
            public CallableData call() throws Exception {
                try {
                    return new CallableData(url, GadgetsHandler.this.handlerService.getToken(tokenRequest));
                }
                catch (Exception e) {
                    return new CallableData(url, GadgetsHandler.this.handlerService.createErrorResponse(null, e, GadgetsHandler.FAILURE_TOKEN));
                }
            }
        };
    }

    protected Callable<CallableData> createProxyJob(final String url, BaseRequestItem request) throws ProcessingException {
        final ProxyRequestData proxyRequest = new ProxyRequestData(url, request);
        return new Callable<CallableData>(){

            @Override
            public CallableData call() throws Exception {
                try {
                    return new CallableData(url, GadgetsHandler.this.handlerService.getProxy(proxyRequest));
                }
                catch (Exception e) {
                    return new CallableData(url, GadgetsHandler.this.handlerService.createErrorResponse(null, e, GadgetsHandler.FAILURE_PROXY));
                }
            }
        };
    }

    protected Callable<CallableData> createCajaJob(final String url, BaseRequestItem request) throws ProcessingException {
        final CajaRequestData cajaRequest = new CajaRequestData(url, request);
        return new Callable<CallableData>(){

            @Override
            public CallableData call() throws Exception {
                try {
                    return new CallableData(url, GadgetsHandler.this.handlerService.getCaja(cajaRequest));
                }
                catch (Exception e) {
                    return new CallableData(url, GadgetsHandler.this.handlerService.createErrorResponse(null, e, GadgetsHandler.FAILURE_CAJA));
                }
            }
        };
    }

    private GadgetsHandlerApi.RenderingContext getRenderingContext(String param) {
        GadgetsHandlerApi.RenderingContext context = GadgetsHandlerApi.RenderingContext.GADGET;
        if ("1".equals(param)) {
            context = GadgetsHandlerApi.RenderingContext.CONTAINER;
        } else if ("2".equals(param)) {
            context = GadgetsHandlerApi.RenderingContext.CONFIGURED_GADGET;
        }
        return context;
    }

    @VisibleForTesting
    static GadgetsHandlerApi.RenderingType getRenderingType(String value) throws ProcessingException {
        GadgetsHandlerApi.RenderingType type = GadgetsHandlerApi.RenderingType.DEFAULT;
        if (value != null) {
            try {
                type = GadgetsHandlerApi.RenderingType.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ProcessingException("Error parsing rendering type parameter", 400);
            }
        }
        return type;
    }

    protected class MetadataRequestData
    extends AbstractRequest
    implements GadgetsHandlerApi.MetadataRequest {
        protected final Locale locale;
        protected final boolean ignoreCache;
        protected final boolean debug;
        protected final GadgetsHandlerApi.RenderingType renderingType;

        public MetadataRequestData(String url, BaseRequestItem request) throws ProcessingException {
            super(url, request, DEFAULT_METADATA_FIELDS);
            String lang = request.getParameter("language");
            String country = request.getParameter("country");
            this.locale = lang != null && country != null ? new Locale(lang, country) : (lang != null ? new Locale(lang) : GadgetSpec.DEFAULT_LOCALE);
            this.ignoreCache = this.getBooleanParam(request, Param.NO_CACHE);
            this.debug = this.getBooleanParam(request, Param.DEBUG);
            this.renderingType = GadgetsHandler.getRenderingType(this.getParam(request, Param.RENDER_TYPE));
        }

        public int getModuleId() {
            return 1;
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }

        @Override
        public boolean getIgnoreCache() {
            return this.ignoreCache;
        }

        @Override
        public boolean getDebug() {
            return this.debug;
        }

        @Override
        public String getView() {
            return this.getParam(this.request, Param.VIEW, "default");
        }

        @Override
        public GadgetsHandlerApi.AuthContext getAuthContext() {
            return (GadgetsHandlerApi.AuthContext)GadgetsHandler.this.beanDelegator.createDelegator((Object)this.request.getToken(), GadgetsHandlerApi.AuthContext.class);
        }

        @Override
        public GadgetsHandlerApi.RenderingType getRenderingType() {
            return this.renderingType;
        }
    }

    protected class CajaRequestData
    extends AbstractRequest
    implements GadgetsHandlerApi.CajaRequest {
        private final String mimeType;
        private final boolean debug;

        public CajaRequestData(String url, BaseRequestItem request) throws ProcessingException {
            super(url, request, DEFAULT_CAJA_FIELDS);
            this.mimeType = this.getParam(request, Param.MIME_TYPE, "text/html");
            this.debug = this.getBooleanParam(request, Param.DEBUG);
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public boolean getDebug() {
            return this.debug;
        }
    }

    protected class TokenRequestData
    extends AbstractRequest
    implements GadgetsHandlerApi.TokenRequest {
        private Long moduleId;

        public TokenRequestData(String url, BaseRequestItem request) throws ProcessingException {
            super(url, request, DEFAULT_TOKEN_FIELDS);
            String moduleId = this.uri.getFragmentParameter("moduleId");
            this.moduleId = moduleId == null ? 0L : Long.valueOf(moduleId);
        }

        @Override
        public GadgetsHandlerApi.AuthContext getAuthContext() {
            return (GadgetsHandlerApi.AuthContext)GadgetsHandler.this.beanDelegator.createDelegator((Object)this.request.getToken(), GadgetsHandlerApi.AuthContext.class);
        }

        @Override
        public Long getModuleId() {
            return this.moduleId;
        }
    }

    protected class ProxyRequestData
    extends AbstractRequest
    implements GadgetsHandlerApi.ProxyRequest {
        private final String gadget;
        private final Integer refresh;
        private final boolean debug;
        private final boolean ignoreCache;
        private final String fallbackUrl;
        private final String mimetype;
        private final boolean sanitize;
        private final GadgetsHandlerApi.ImageParams imageParams;

        public ProxyRequestData(String url, BaseRequestItem request) throws ProcessingException {
            super(url, request, DEFAULT_PROXY_FIELDS);
            this.ignoreCache = this.getBooleanParam(request, Param.NO_CACHE);
            this.debug = this.getBooleanParam(request, Param.DEBUG);
            this.sanitize = this.getBooleanParam(request, Param.SANITIZE);
            this.gadget = this.getParam(request, Param.GADGET);
            this.fallbackUrl = this.getParam(request, Param.FALLBACK_URL);
            this.mimetype = this.getParam(request, Param.REWRITE_MIME);
            this.refresh = this.getIntegerParam(request, Param.REFRESH);
            this.imageParams = this.getImageParams(request);
        }

        private GadgetsHandlerApi.ImageParams getImageParams(BaseRequestItem request) throws ProcessingException {
            GadgetsHandlerApi.ImageParams params = null;
            Boolean doNotExpand = this.getBooleanParam(request, Param.NO_EXPAND);
            Integer height = this.getIntegerParam(request, Param.RESIZE_HEIGHT);
            Integer width = this.getIntegerParam(request, Param.RESIZE_WIDTH);
            Integer quality = this.getIntegerParam(request, Param.RESIZE_QUALITY);
            if (height != null || width != null) {
                return (GadgetsHandlerApi.ImageParams)GadgetsHandler.this.beanDelegator.createDelegator(null, GadgetsHandlerApi.ImageParams.class, (Map)ImmutableMap.of((Object)"height", (Object)BeanDelegator.nullable((Object)height), (Object)"width", (Object)BeanDelegator.nullable((Object)width), (Object)"quality", (Object)BeanDelegator.nullable((Object)quality), (Object)"donotexpand", (Object)BeanDelegator.nullable((Object)doNotExpand)));
            }
            return params;
        }

        @Override
        public boolean getDebug() {
            return this.debug;
        }

        @Override
        public String getFallbackUrl() {
            return this.fallbackUrl;
        }

        @Override
        public boolean getIgnoreCache() {
            return this.ignoreCache;
        }

        @Override
        public GadgetsHandlerApi.ImageParams getImageParams() {
            return this.imageParams;
        }

        @Override
        public Integer getRefresh() {
            return this.refresh;
        }

        @Override
        public String getRewriteMimeType() {
            return this.mimetype;
        }

        @Override
        public boolean getSanitize() {
            return this.sanitize;
        }

        @Override
        public String getGadget() {
            return this.gadget;
        }
    }

    protected class JsRequestData
    extends AbstractRequest
    implements GadgetsHandlerApi.JsRequest {
        private final Integer refresh;
        private final boolean debug;
        private final boolean ignoreCache;
        private final List<String> features;
        private final List<String> loadedFeatures;
        private final GadgetsHandlerApi.RenderingContext context;
        private final String onload;
        private final String gadget;
        private final String repository;

        public JsRequestData(BaseRequestItem request) throws ProcessingException {
            super(null, request, DEFAULT_JS_FIELDS);
            this.ignoreCache = this.getBooleanParam(request, Param.NO_CACHE);
            this.debug = this.getBooleanParam(request, Param.DEBUG);
            this.refresh = this.getIntegerParam(request, Param.REFRESH);
            this.features = this.getListParam(request, Param.FEATURES);
            this.loadedFeatures = this.getListParam(request, Param.LOADED_FEATURES);
            this.context = GadgetsHandler.this.getRenderingContext(this.getParam(request, Param.CONTAINER_MODE));
            this.onload = this.getParam(request, Param.ONLOAD);
            this.gadget = this.getParam(request, Param.GADGET);
            this.repository = this.getParam(request, Param.REPOSITORY);
        }

        @Override
        public GadgetsHandlerApi.RenderingContext getContext() {
            return this.context;
        }

        @Override
        public boolean getDebug() {
            return this.debug;
        }

        @Override
        public List<String> getFeatures() {
            return this.features;
        }

        @Override
        public List<String> getLoadedFeatures() {
            return this.loadedFeatures;
        }

        @Override
        public boolean getIgnoreCache() {
            return this.ignoreCache;
        }

        @Override
        public String getOnload() {
            return this.onload;
        }

        @Override
        public Integer getRefresh() {
            return this.refresh;
        }

        @Override
        public String getGadget() {
            return this.gadget;
        }

        @Override
        public String getRepository() {
            return this.repository;
        }
    }

    private abstract class AbstractRequest
    implements GadgetsHandlerApi.BaseRequest {
        protected final Uri uri;
        protected final String container;
        protected final List<String> fields;
        protected final BaseRequestItem request;

        public AbstractRequest(String url, BaseRequestItem request, List<String> defaultFields) throws ProcessingException {
            try {
                this.uri = url != null ? Uri.parse((String)url) : null;
            }
            catch (Uri.UriException e) {
                throw new ProcessingException("Bad url - " + url, 400);
            }
            this.request = request;
            this.container = request.getParameter(Param.CONTAINER.getName());
            this.fields = this.processFields(request, defaultFields);
        }

        protected String getParam(BaseRequestItem request, Param field) {
            return request.getParameter(field.getName());
        }

        protected String getParam(BaseRequestItem request, Param field, String defaultValue) {
            return request.getParameter(field.getName(), defaultValue);
        }

        protected List<String> getListParam(BaseRequestItem request, Param field) {
            return request.getListParameter(field.getName());
        }

        protected Boolean getBooleanParam(BaseRequestItem request, Param field) {
            String val = request.getParameter(field.getName());
            if (val != null) {
                return "1".equals(val) || Boolean.valueOf(val) != false;
            }
            return false;
        }

        protected Integer getIntegerParam(BaseRequestItem request, Param field) throws ProcessingException {
            String val = request.getParameter(field.getName());
            Integer intVal = null;
            if (val != null) {
                try {
                    intVal = Integer.valueOf(val);
                }
                catch (NumberFormatException e) {
                    throw new ProcessingException("Error parsing " + (Object)((Object)field) + " parameter", 400);
                }
            }
            return intVal;
        }

        @Override
        public Uri getUrl() {
            return this.uri;
        }

        @Override
        public String getContainer() {
            return this.container;
        }

        @Override
        public List<String> getFields() {
            return this.fields;
        }

        private List<String> processFields(BaseRequestItem request, List<String> defaultList) {
            List value = request.getListParameter("fields");
            return value == null || value.isEmpty() ? defaultList : value;
        }
    }

    private abstract class AbstractExecutor {
        private AbstractExecutor() {
        }

        public Map<String, GadgetsHandlerApi.BaseResponse> execute(BaseRequestItem request) {
            ImmutableSet gadgetUrls = ImmutableSet.copyOf((Collection)request.getListParameter(Param.IDS.getName()));
            if (gadgetUrls.isEmpty()) {
                return ImmutableMap.of();
            }
            if (Strings.isNullOrEmpty((String)request.getParameter(Param.CONTAINER.getName()))) {
                throw new ProtocolException(400, "Missing container for request.");
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int badReq = 0;
            ExecutorCompletionService<CallableData> completionService = new ExecutorCompletionService<CallableData>(GadgetsHandler.this.executor);
            for (String gadgetUrl : gadgetUrls) {
                try {
                    Callable<CallableData> job = this.createJob(gadgetUrl, request);
                    completionService.submit(job);
                }
                catch (ProcessingException e) {
                    builder.put((Object)gadgetUrl, (Object)GadgetsHandler.this.handlerService.createErrorResponse(null, e.getHttpStatusCode(), e.getMessage()));
                    ++badReq;
                }
            }
            for (int numJobs = gadgetUrls.size() - badReq; numJobs > 0; --numJobs) {
                try {
                    CallableData response = (CallableData)completionService.take().get();
                    builder.put((Object)response.getId(), (Object)response.getData());
                    continue;
                }
                catch (InterruptedException e) {
                    throw new ProtocolException(500, "Processing interrupted.", (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new ProtocolException(500, "Processing error.", (Throwable)e);
                }
            }
            return builder.build();
        }

        protected abstract Callable<CallableData> createJob(String var1, BaseRequestItem var2) throws ProcessingException;
    }

    class CallableData {
        private final String id;
        private final GadgetsHandlerApi.BaseResponse data;

        public CallableData(String id, GadgetsHandlerApi.BaseResponse data) {
            this.id = id;
            this.data = data;
        }

        public String getId() {
            return this.id;
        }

        public GadgetsHandlerApi.BaseResponse getData() {
            return this.data;
        }
    }

    static enum Param {
        IDS("ids"),
        CONTAINER(UriCommon.Param.CONTAINER.getKey()),
        FIELDS("fields"),
        DEBUG(UriCommon.Param.DEBUG),
        NO_CACHE(UriCommon.Param.NO_CACHE),
        REFRESH(UriCommon.Param.REFRESH),
        LANG(UriCommon.Param.LANG),
        COUNTRY(UriCommon.Param.COUNTRY),
        VIEW(UriCommon.Param.VIEW),
        RENDER_TYPE("render"),
        SANITIZE(UriCommon.Param.SANITIZE),
        GADGET(UriCommon.Param.GADGET),
        FALLBACK_URL(UriCommon.Param.FALLBACK_URL_PARAM),
        REWRITE_MIME(UriCommon.Param.REWRITE_MIME_TYPE),
        NO_EXPAND(UriCommon.Param.NO_EXPAND),
        RESIZE_HEIGHT(UriCommon.Param.RESIZE_HEIGHT),
        RESIZE_WIDTH(UriCommon.Param.RESIZE_WIDTH),
        RESIZE_QUALITY(UriCommon.Param.RESIZE_QUALITY),
        FEATURES("features"),
        LOADED_FEATURES("loadedFeatures"),
        CONTAINER_MODE(UriCommon.Param.CONTAINER_MODE),
        ONLOAD(UriCommon.Param.ONLOAD),
        REPOSITORY(UriCommon.Param.REPOSITORY_ID),
        MIME_TYPE("mime_type");

        private final String name;

        private Param(String name) {
            this.name = name;
        }

        private Param(UriCommon.Param param) {
            this.name = param.getKey();
        }

        String getName() {
            return this.name;
        }
    }
}

