/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.protocol.conversion.BeanFilter;

public class GadgetsHandlerApi {

    public static interface JsResponse
    extends BaseResponse {
        public Uri getJsUrl();

        public String getJsContent();
    }

    public static enum RenderingContext {
        GADGET,
        CONTAINER,
        CONFIGURED_GADGET;

    }

    public static interface JsRequest
    extends BaseRequest {
        public String getGadget();

        public Integer getRefresh();

        public boolean getDebug();

        public boolean getIgnoreCache();

        public List<String> getFeatures();

        public List<String> getLoadedFeatures();

        public String getOnload();

        public RenderingContext getContext();

        public String getRepository();
    }

    public static interface NameValuePair {
        public String getName();

        public String getValue();
    }

    public static interface HttpResponse {
        public int getCode();

        public String getEncoding();

        public String getContentBase64();

        public List<NameValuePair> getHeaders();
    }

    public static interface ProxyResponse
    extends BaseResponse {
        public Uri getProxyUrl();

        public HttpResponse getProxyContent();
    }

    public static interface ImageParams {
        public Integer getHeight();

        public Integer getWidth();

        public Integer getQuality();

        public Boolean getDoNotExpand();
    }

    public static interface ProxyRequest
    extends BaseRequest {
        public String getGadget();

        public Integer getRefresh();

        public boolean getDebug();

        public boolean getIgnoreCache();

        public String getFallbackUrl();

        public String getRewriteMimeType();

        public boolean getSanitize();

        public ImageParams getImageParams();
    }

    public static enum Location {
        HEADER("auth-header"),
        URL("uri-query"),
        BODY("post-body");

        private String locationString;

        private Location(String locationString) {
            this.locationString = locationString;
        }

        public String toString() {
            return this.locationString;
        }
    }

    public static enum Method {
        GET,
        POST;

    }

    public static enum MessageLevel {
        UNKNOWN,
        LOG,
        SUMMARY,
        INFERENCE,
        LINT,
        WARNING,
        ERROR,
        FATAL_ERROR;

    }

    public static interface Message {
        public MessageLevel getLevel();

        public String getName();

        public String getMessage();
    }

    public static interface CajaResponse
    extends BaseResponse {
        public String getHtml();

        public String getJs();

        public List<Message> getMessages();
    }

    public static interface CajaRequest
    extends BaseRequest {
        public String getMimeType();

        public boolean getDebug();
    }

    public static interface TokenResponse
    extends BaseResponse {
        public String getToken();

        public Integer getTokenTTL();

        public Long getModuleId();
    }

    public static interface TokenRequest
    extends BaseRequest {
        public AuthContext getAuthContext();

        public Long getModuleId();
    }

    public static interface OAuth2Service {
        public EndPoint getAuthorizationUrl();

        public EndPoint getTokenUrl();

        public String getScope();

        public String getName();
    }

    public static interface EndPoint {
        public Uri getUrl();

        public Method getMethod();

        public Location getLocation();
    }

    public static interface OAuthService {
        public EndPoint getRequestUrl();

        public EndPoint getAccessUrl();

        public Uri getAuthorizationUrl();

        public String getName();
    }

    public static interface OAuth2Spec {
        public Map<String, OAuth2Service> getServices();
    }

    public static interface OAuthSpec {
        public Map<String, OAuthService> getServices();
    }

    public static interface LinkSpec {
        public String getRel();

        public Uri getHref();

        public String getMethod();
    }

    public static interface Feature {
        public String getName();

        public boolean getRequired();

        public Multimap<String, String> getParams();
    }

    public static interface ModulePrefs {
        public String getTitle();

        public Uri getTitleUrl();

        public String getDescription();

        public String getAuthor();

        public String getAuthorEmail();

        public Uri getScreenshot();

        public Uri getThumbnail();

        public String getDirectoryTitle();

        public String getAuthorAffiliation();

        public String getAuthorLocation();

        public Uri getAuthorPhoto();

        public String getAuthorAboutme();

        public String getAuthorQuote();

        public Uri getAuthorLink();

        public boolean getScaling();

        public boolean getScrolling();

        public int getWidth();

        public int getHeight();

        public List<String> getCategories();

        public Map<String, Feature> getFeatures();

        public Map<String, LinkSpec> getLinks();

        public OAuthSpec getOAuthSpec();

        public OAuth2Spec getOAuth2Spec();
    }

    public static interface EnumValuePair {
        public String getValue();

        public String getDisplayValue();
    }

    public static interface UserPref {
        public String getName();

        public String getDisplayName();

        public String getDefaultValue();

        public boolean getRequired();

        public UserPrefDataType getDataType();

        public List<EnumValuePair> getOrderedEnumValues();
    }

    public static enum UserPrefDataType {
        STRING,
        HIDDEN,
        BOOL,
        ENUM,
        LIST,
        NUMBER;

    }

    public static interface View {
        public String getName();

        public ViewContentType getType();

        public Uri getHref();

        public boolean getQuirks();

        public int getPreferredHeight();

        public int getPreferredWidth();
    }

    public static enum ViewContentType {
        HTML("html"),
        URL("url"),
        HTML_SANITIZED("x-html-sanitized");

        private final String name;

        private ViewContentType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface MetadataResponse
    extends BaseResponse {
        public Map<String, String> getIframeUrls();

        public String getChecksum();

        public ModulePrefs getModulePrefs();

        public Map<String, UserPref> getUserPrefs();

        public Map<String, View> getViews();

        public Boolean getNeedsTokenRefresh();

        public Set<String> getRpcServiceIds();

        public Integer getTokenTTL();
    }

    public static interface AuthContext {
        public String getOwnerId();

        public String getViewerId();

        public String getDomain();

        public long getModuleId();

        public String getAuthenticationMode();

        public Long getExpiresAt();

        public String getTrustedJson();
    }

    public static enum RenderingType {
        DEFAULT,
        SANITIZED,
        INLINE_CAJOLED,
        IFRAME_CAJOLED;

    }

    public static interface MetadataRequest
    extends BaseRequest {
        public Locale getLocale();

        public boolean getIgnoreCache();

        public boolean getDebug();

        public String getView();

        public AuthContext getAuthContext();

        public RenderingType getRenderingType();
    }

    public static interface BaseResponse {
        public Uri getUrl();

        @BeanFilter.Unfiltered
        public Error getError();

        @BeanFilter.Unfiltered
        public Long getExpireTimeMs();

        @BeanFilter.Unfiltered
        public Long getResponseTimeMs();
    }

    public static interface Error {
        public int getCode();

        public String getMessage();
    }

    public static interface BaseRequest {
        public String getContainer();

        public List<String> getFields();

        public Uri getUrl();
    }
}

