/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsRequestBuilder;
import org.apache.shindig.gadgets.js.JsResponse;
import org.apache.shindig.gadgets.js.JsServingPipeline;

public class JsServlet
extends InjectedServlet {
    private static final long serialVersionUID = 6255917470412008175L;
    private JsServingPipeline jsServingPipeline;
    private CachingSetter cachingSetter;
    private JsRequestBuilder jsRequestBuilder;

    @Inject
    public void setJsRequestBuilder(JsRequestBuilder jsRequestBuilder) {
        this.checkInitialized();
        this.jsRequestBuilder = jsRequestBuilder;
    }

    @Inject
    public void setCachingSetter(CachingSetter cachingSetter) {
        this.cachingSetter = cachingSetter;
    }

    @Inject
    public void setJsServingPipeline(JsServingPipeline jsServingPipeline) {
        this.jsServingPipeline = jsServingPipeline;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JsResponse jsResponse;
        JsRequest jsRequest;
        try {
            jsRequest = this.jsRequestBuilder.build(req);
        }
        catch (GadgetException e) {
            resp.setStatus(400);
            return;
        }
        try {
            jsResponse = this.jsServingPipeline.execute(jsRequest);
        }
        catch (JsException e) {
            resp.sendError(e.getStatusCode(), e.getMessage());
            return;
        }
        this.emitJsResponse(jsResponse, req, resp);
    }

    protected void emitJsResponse(JsResponse jsResponse, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (jsResponse.getStatusCode() == 304) {
            resp.setStatus(304);
            this.cachingSetter.setCachingHeaders(resp, jsResponse.getCacheTtlSecs(), !jsResponse.isProxyCacheable());
            return;
        }
        if (jsResponse.getStatusCode() == 200 && jsResponse.toJsString().length() == 0) {
            resp.setStatus(404);
            return;
        }
        this.cachingSetter.setCachingHeaders(resp, jsResponse.getCacheTtlSecs(), !jsResponse.isProxyCacheable());
        resp.setStatus(jsResponse.getStatusCode());
        resp.setContentType("text/javascript; charset=utf-8");
        byte[] response = CharsetUtil.getUtf8Bytes((String)jsResponse.toJsString());
        resp.setContentLength(response.length);
        resp.getOutputStream().write(response);
    }

    @VisibleForTesting
    static class CachingSetter {
        CachingSetter() {
        }

        public void setCachingHeaders(HttpServletResponse resp, int ttl, boolean noProxy) {
            if (ttl < 0) {
                HttpUtil.setCachingHeaders((HttpServletResponse)resp, (boolean)noProxy);
            } else if (ttl == 0) {
                HttpUtil.setNoCache((HttpServletResponse)resp);
            } else {
                HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)ttl, (boolean)noProxy);
            }
        }
    }
}

