/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.util.ContentType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import org.apache.shindig.gadgets.servlet.ModuleCacheKeys;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class ModuleCacheKey
implements JobCache.Key {
    private final byte[] hashBytes;
    private final int first32Bits;

    ModuleCacheKey(ContentType type, ParseTreeNode node) {
        Hasher hasher = new Hasher(type);
        hasher.hash(node);
        this.hashBytes = hasher.getHashBytes();
        this.first32Bits = this.hashBytes[0] & 0xFF | (this.hashBytes[1] & 0xFF) << 8 | (this.hashBytes[2] & 0xFF) << 16 | (this.hashBytes[3] & 0xFF) << 24;
    }

    public ModuleCacheKeys asSingleton() {
        return new ModuleCacheKeys(this);
    }

    public boolean equals(Object o) {
        return o instanceof ModuleCacheKey && Arrays.equals(this.hashBytes, ((ModuleCacheKey)o).hashBytes);
    }

    public int hashCode() {
        return this.first32Bits;
    }

    private static final class Hasher {
        final MessageDigest md;
        final byte[] buffer = new byte[1024];
        int posInBuffer;

        Hasher(ContentType t) {
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ex) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(ex));
            }
            this.md.update((byte)t.ordinal());
        }

        byte[] getHashBytes() {
            this.flushBuffer();
            return this.md.digest();
        }

        void hash(ParseTreeNode node) {
            this.hash(System.identityHashCode(node.getClass()));
            Object value = node.getValue();
            if (value != null) {
                if (value instanceof String) {
                    this.hash((String)value);
                } else if (value instanceof Node) {
                    this.hash((Node)value);
                } else {
                    this.hash(value.hashCode());
                }
            }
            List children = node.children();
            this.hash((short)children.size());
            for (ParseTreeNode child : children) {
                this.hash(child);
            }
        }

        private void hash(Node node) {
            this.hash(node.getNodeType());
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    this.hash(node.getNodeName());
                    break;
                }
                case 3: 
                case 4: {
                    this.hash(node.getNodeValue());
                }
            }
            this.hash((short)node.getChildNodes().getLength());
            if (node.getNodeType() == 1) {
                NamedNodeMap attrs = node.getAttributes();
                int nAttrs = attrs.getLength();
                this.hash((short)nAttrs);
                for (int i = 0; i < nAttrs; ++i) {
                    this.hash(attrs.item(i));
                }
            }
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.hash(child);
            }
        }

        private void hash(int n) {
            this.requireSpaceInBuffer(4);
            this.buffer[++this.posInBuffer] = (byte)(n >> 24 & 0xFF);
            this.buffer[++this.posInBuffer] = (byte)(n >> 16 & 0xFF);
            this.buffer[++this.posInBuffer] = (byte)(n >> 8 & 0xFF);
            this.buffer[++this.posInBuffer] = (byte)(n & 0xFF);
        }

        private void hash(short n) {
            this.requireSpaceInBuffer(2);
            this.buffer[++this.posInBuffer] = (byte)(n >> 8 & 0xFF);
            this.buffer[++this.posInBuffer] = (byte)(n & 0xFF);
        }

        private void hash(String text) {
            int n = text.length();
            for (int i = 0; i < n; ++i) {
                char ch = text.charAt(i);
                if (ch < '\u0080') {
                    this.requireSpaceInBuffer(1);
                    this.buffer[++this.posInBuffer] = (byte)ch;
                    continue;
                }
                if (ch < '\u0080') {
                    this.requireSpaceInBuffer(2);
                    this.buffer[++this.posInBuffer] = (byte)(ch >> 6 & 0x1F | 0xC0);
                    this.buffer[++this.posInBuffer] = (byte)(ch & 0x3F | 0x80);
                    continue;
                }
                this.requireSpaceInBuffer(3);
                this.buffer[++this.posInBuffer] = (byte)(ch >> 12 & 0xF | 0xE0);
                this.buffer[++this.posInBuffer] = (byte)(ch >> 6 & 0x3F | 0x80);
                this.buffer[++this.posInBuffer] = (byte)(ch & 0x3F | 0x80);
            }
        }

        private void requireSpaceInBuffer(int space) {
            if (this.posInBuffer + space >= this.buffer.length) {
                this.flushBuffer();
            }
        }

        private void flushBuffer() {
            this.md.update(this.buffer, 0, this.posInBuffer + 1);
            this.posInBuffer = -1;
        }
    }
}

