/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.BaseOAuthService;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OAuth2Service
extends BaseOAuthService {
    private BaseOAuthService.EndPoint authorizationUrl;
    private BaseOAuthService.EndPoint tokenUrl;
    private String name;
    private String scope;

    OAuth2Service() {
    }

    public OAuth2Service(Element serviceElement, Uri base) throws SpecParserException {
        this.name = serviceElement.getAttribute("name");
        this.scope = serviceElement.getAttribute("scope");
        NodeList children = serviceElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName();
            if ("Authorization".equals(childName)) {
                if (this.authorizationUrl != null) {
                    throw new SpecParserException("Multiple OAuth2/Service/Authorization elements");
                }
                this.authorizationUrl = this.parseEndPoint("OAuth2/Service/Authorization", (Element)child, base);
                continue;
            }
            if (!"Token".equals(childName)) continue;
            if (this.tokenUrl != null) {
                throw new SpecParserException("Multiple OAuth2/Service/Token elements");
            }
            this.tokenUrl = this.parseEndPoint("OAuth2/Service/Token", (Element)child, base);
        }
    }

    public BaseOAuthService.EndPoint getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public BaseOAuthService.EndPoint getTokenUrl() {
        return this.tokenUrl;
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

