/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.shindig.gadgets.ContentCache;
import org.apache.shindig.gadgets.RemoteContent;
import org.apache.shindig.gadgets.RemoteContentRequest;

public class BasicContentCache
implements ContentCache {
    private static final DateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
    private final Map<URI, RemoteContent> cache = new WeakHashMap<URI, RemoteContent>();

    public RemoteContent getContent(URI uri) {
        if (uri == null) {
            return null;
        }
        return this.checkContent(this.cache.get(uri));
    }

    public RemoteContent getContent(RemoteContentRequest request) {
        if (this.canCacheRequest(request)) {
            return this.getContent(request.getUri());
        }
        return null;
    }

    public void addContent(URI uri, RemoteContent content) {
        content = this.checkContent(content);
        if (uri == null || content == null) {
            return;
        }
        this.cache.put(URI.create(uri.toString()), content);
    }

    public void addContent(RemoteContentRequest request, RemoteContent content) {
        if (this.canCacheRequest(request)) {
            this.addContent(request.getUri(), content);
        }
    }

    public RemoteContent removeContent(URI uri) {
        if (uri == null) {
            return null;
        }
        RemoteContent content = this.cache.get(uri);
        this.cache.remove(uri);
        return this.checkContent(content);
    }

    public RemoteContent removeContent(RemoteContentRequest request) {
        return this.removeContent(request.getUri());
    }

    protected boolean canCacheRequest(RemoteContentRequest request) {
        return "GET".equals(request.getMethod()) && !request.getOptions().ignoreCache;
    }

    protected RemoteContent checkContent(RemoteContent content) {
        List<String> pragmas;
        if (content == null) {
            return null;
        }
        if (content.getHttpStatusCode() != 200) {
            return null;
        }
        long now = System.currentTimeMillis();
        String expires = content.getHeader("Expires");
        if (expires != null) {
            try {
                Date expiresDate = dateFormat.parse(expires);
                long expiresMs = expiresDate.getTime();
                if (expiresMs > now) {
                    return content;
                }
                return null;
            }
            catch (ParseException e) {
                return null;
            }
        }
        String cacheControl = content.getHeader("Cache-Control");
        if (cacheControl != null) {
            String[] directives;
            for (String directive : directives = cacheControl.split(",")) {
                String[] parts;
                if ((directive = directive.trim()).equals("no-cache")) {
                    return null;
                }
                if (!directive.startsWith("max-age") || (parts = directive.split("=")).length != 2) continue;
                try {
                    long maxAgeMs = Long.parseLong(parts[1]) * 1000L;
                    Date newExpiry = new Date(now + maxAgeMs);
                    content.getAllHeaders().put("Expires", Arrays.asList(dateFormat.format(newExpiry)));
                    return content;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        if ((pragmas = content.getHeaders("Pragma")) != null) {
            for (String pragma : pragmas) {
                if (!"no-cache".equals(pragma)) continue;
                return null;
            }
        }
        Date newExpiry = new Date(now + this.getDefaultTTL());
        content.getAllHeaders().put("Expires", Arrays.asList(dateFormat.format(newExpiry)));
        return content;
    }

    protected long getDefaultTTL() {
        return 300000L;
    }
}

