/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.util.BasicBlobCrypter;
import org.apache.shindig.util.BlobCrypter;
import org.apache.shindig.util.BlobCrypterException;

public class BasicGadgetToken
implements GadgetToken {
    private final String token;
    private final Map<String, String> tokenData;
    private BlobCrypter crypter = new BasicBlobCrypter(INSECURE_KEY);
    private static final byte[] INSECURE_KEY = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String OWNER_KEY = "o";
    private static final String APP_KEY = "a";
    private static final String VIEWER_KEY = "v";
    private static final String DOMAIN_KEY = "d";
    private static final String APPURL_KEY = "u";
    private static final String MODULE_KEY = "m";

    public String toSerialForm() {
        return this.token;
    }

    public BasicGadgetToken(String token, int maxAge) throws BlobCrypterException {
        this.token = token;
        this.tokenData = this.crypter.unwrap(token, maxAge);
    }

    public BasicGadgetToken(String owner, String viewer, String app, String domain, String appUrl, String moduleId) throws BlobCrypterException {
        this.tokenData = new HashMap<String, String>(5, 1.0f);
        this.tokenData.put(OWNER_KEY, owner);
        this.tokenData.put(VIEWER_KEY, viewer);
        this.tokenData.put(APP_KEY, app);
        this.tokenData.put(DOMAIN_KEY, domain);
        this.tokenData.put(APPURL_KEY, appUrl);
        this.tokenData.put(MODULE_KEY, moduleId);
        this.token = this.crypter.wrap(this.tokenData);
    }

    public String getAppId() {
        return this.tokenData.get(APP_KEY);
    }

    public String getDomain() {
        return this.tokenData.get(DOMAIN_KEY);
    }

    public String getOwnerId() {
        return this.tokenData.get(OWNER_KEY);
    }

    public String getViewerId() {
        return this.tokenData.get(VIEWER_KEY);
    }

    public String getAppUrl() {
        return this.tokenData.get(APPURL_KEY);
    }

    public long getModuleId() {
        return Long.parseLong(this.tokenData.get(MODULE_KEY));
    }
}

