/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.shindig.gadgets.BasicGadgetToken;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.gadgets.GadgetTokenDecoder;
import org.apache.shindig.util.BlobCrypterException;

public class BasicGadgetTokenDecoder
implements GadgetTokenDecoder {
    private static final int OWNER_INDEX = 0;
    private static final int VIEWER_INDEX = 1;
    private static final int APP_ID_INDEX = 2;
    private static final int CONTAINER_INDEX = 3;
    private static final int APP_URL_INDEX = 4;
    private static final int MODULE_ID_INDEX = 5;

    public GadgetToken createToken(String stringToken) throws GadgetException {
        try {
            String[] tokens = stringToken.split(":");
            return new BasicGadgetToken(URLDecoder.decode(tokens[0], "UTF-8"), URLDecoder.decode(tokens[1], "UTF-8"), URLDecoder.decode(tokens[2], "UTF-8"), URLDecoder.decode(tokens[3], "UTF-8"), URLDecoder.decode(tokens[4], "UTF-8"), URLDecoder.decode(tokens[5], "UTF-8"));
        }
        catch (BlobCrypterException e) {
            throw new GadgetException(GadgetException.Code.INVALID_GADGET_TOKEN, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GadgetException(GadgetException.Code.INVALID_GADGET_TOKEN, (Throwable)e);
        }
    }
}

