/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.shindig.gadgets.ContentCache;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.RemoteContent;
import org.apache.shindig.gadgets.RemoteContentRequest;
import org.apache.shindig.util.InputStreamConsumer;

@Singleton
public class BasicRemoteContentFetcher
implements ContentFetcher {
    private static final int CONNECT_TIMEOUT_MS = 5000;
    private static final int DEFAULT_MAX_OBJECT_SIZE = 0x100000;
    private final int maxObjSize;
    private final ContentCache cache;

    public BasicRemoteContentFetcher(ContentCache cache, int maxObjSize) {
        this.maxObjSize = maxObjSize;
        this.cache = cache;
    }

    @Inject
    public BasicRemoteContentFetcher(ContentCache cache) {
        this(cache, 0x100000);
    }

    private URLConnection getConnection(RemoteContentRequest request) throws IOException {
        URLConnection fetcher = request.getUri().toURL().openConnection();
        fetcher.setConnectTimeout(5000);
        fetcher.setRequestProperty("Accept-Encoding", "gzip, deflate");
        if (fetcher instanceof HttpURLConnection) {
            ((HttpURLConnection)fetcher).setInstanceFollowRedirects(true);
            Map<String, List<String>> reqHeaders = request.getAllHeaders();
            for (Map.Entry<String, List<String>> entry : reqHeaders.entrySet()) {
                List<String> value = entry.getValue();
                if (value.size() == 1) {
                    fetcher.setRequestProperty(entry.getKey(), value.get(0));
                    continue;
                }
                StringBuilder headerList = new StringBuilder();
                boolean first = false;
                for (String val : value) {
                    if (!first) {
                        first = true;
                    } else {
                        headerList.append(',');
                    }
                    headerList.append(val);
                }
                fetcher.setRequestProperty(entry.getKey(), headerList.toString());
            }
        }
        fetcher.setDefaultUseCaches(!request.getOptions().ignoreCache);
        return fetcher;
    }

    private RemoteContent makeResponse(URLConnection fetcher) throws IOException {
        Map<String, List<String>> headers = fetcher.getHeaderFields();
        int responseCode = fetcher instanceof HttpURLConnection ? ((HttpURLConnection)fetcher).getResponseCode() : 200;
        String encoding = fetcher.getContentEncoding();
        InputStream is = null;
        if (encoding == null) {
            is = fetcher.getInputStream();
        } else if (encoding.equalsIgnoreCase("gzip")) {
            is = new GZIPInputStream(fetcher.getInputStream());
        } else if (encoding.equalsIgnoreCase("deflate")) {
            Inflater inflater = new Inflater(true);
            is = new InflaterInputStream(fetcher.getInputStream(), inflater);
        }
        byte[] body = InputStreamConsumer.readToByteArray(is, this.maxObjSize);
        return new RemoteContent(responseCode, body, headers);
    }

    public RemoteContent fetch(RemoteContentRequest request) {
        RemoteContent content = this.cache.getContent(request);
        if (content != null) {
            return content;
        }
        try {
            URLConnection fetcher = this.getConnection(request);
            if ("POST".equals(request.getMethod()) && fetcher instanceof HttpURLConnection) {
                ((HttpURLConnection)fetcher).setRequestMethod("POST");
                fetcher.setRequestProperty("Content-Length", String.valueOf(request.getPostBodyLength()));
                fetcher.setUseCaches(false);
                fetcher.setDoInput(true);
                fetcher.setDoOutput(true);
                InputStreamConsumer.pipe(request.getPostBody(), fetcher.getOutputStream());
            }
            content = this.makeResponse(fetcher);
            this.cache.addContent(request, content);
            return content;
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                return RemoteContent.NOT_FOUND;
            }
            return RemoteContent.ERROR;
        }
    }
}

