/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.util.ResourceLoader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerConfig {
    private final Map<String, JSONObject> config = new HashMap<String, JSONObject>();
    public static final String DEFAULT_CONTAINER = "default";
    public static final String CONTAINER_KEY = "gadgets.container";
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");

    public Set<String> getContainers() {
        return Collections.unmodifiableSet(this.config.keySet());
    }

    public Object getJson(String container, String parameter) {
        JSONObject data = this.config.get(container);
        if (data == null) {
            return null;
        }
        if (parameter == null) {
            return data;
        }
        try {
            for (String param : parameter.split("/")) {
                Object next = data.get(param);
                if (!(next instanceof JSONObject)) {
                    return next;
                }
                data = (JSONObject)next;
            }
            return data;
        }
        catch (JSONException e) {
            logger.log(Level.WARNING, "Failed to get JSON config", e);
            return null;
        }
    }

    public String get(String container, String parameter) {
        Object data = this.getJson(container, parameter);
        return data == null ? null : data.toString();
    }

    public JSONObject getJsonObject(String container, String parameter) {
        Object data = this.getJson(container, parameter);
        if (data instanceof JSONObject) {
            return (JSONObject)data;
        }
        return null;
    }

    public JSONArray getJsonArray(String container, String parameter) {
        Object data = this.getJson(container, parameter);
        if (data instanceof JSONArray) {
            return (JSONArray)data;
        }
        return null;
    }

    private void loadFiles(File[] files) throws GadgetException {
        try {
            for (File file : files) {
                logger.info("Reading container config: " + file.getName());
                if (file.isDirectory()) {
                    this.loadFiles(file.listFiles());
                    continue;
                }
                if (!file.getName().endsWith(".js") && !file.getName().endsWith(".json")) continue;
                this.loadFromString(ResourceLoader.getContent(file));
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
    }

    private void loadResources(String[] files) throws GadgetException {
        try {
            for (String entry : files) {
                logger.info("Reading container config: " + entry);
                String content = ResourceLoader.getContent(entry);
                this.loadFromString(content);
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
    }

    private static String[] getNames(JSONObject obj) throws JSONException {
        JSONArray arr = obj.names();
        ArrayList<String> items = new ArrayList<String>(arr.length());
        int j = arr.length();
        for (int i = 0; i < j; ++i) {
            items.add(i, arr.getString(i));
        }
        return items.toArray(new String[items.size()]);
    }

    private JSONObject mergeObjects(JSONObject base, JSONObject merge) throws JSONException {
        String[] fields;
        JSONObject clone = new JSONObject(base, ContainerConfig.getNames(base));
        for (String field : fields = ContainerConfig.getNames(merge)) {
            Object existing = clone.opt(field);
            Object update = merge.get(field);
            if (existing == null || update == null) {
                clone.put(field, update);
                continue;
            }
            if (update instanceof JSONObject && existing instanceof JSONObject) {
                clone.put(field, (Object)this.mergeObjects((JSONObject)existing, (JSONObject)update));
                continue;
            }
            clone.put(field, update);
        }
        return clone;
    }

    public void loadFromString(String json) throws GadgetException {
        try {
            JSONObject contents = new JSONObject(json);
            JSONArray containers = contents.getJSONArray(CONTAINER_KEY);
            JSONObject defaultContainer = this.config.get(DEFAULT_CONTAINER);
            if (defaultContainer == null) {
                if (DEFAULT_CONTAINER.equals(containers.get(0))) {
                    defaultContainer = contents;
                    this.config.put(DEFAULT_CONTAINER, contents);
                } else {
                    throw new GadgetException(GadgetException.Code.INVALID_CONFIG, "No default config registered");
                }
            }
            int j = containers.length();
            for (int i = 0; i < j; ++i) {
                String container = containers.getString(i);
                if (DEFAULT_CONTAINER.equals(container)) continue;
                this.config.put(container, this.mergeObjects(defaultContainer, contents));
            }
        }
        catch (JSONException e) {
            throw new GadgetException(GadgetException.Code.INVALID_CONFIG, (Throwable)e);
        }
    }

    public void loadContainers(String path) throws GadgetException {
        try {
            if (path.startsWith("res://")) {
                path = path.substring(6);
                logger.info("Loading resources from: " + path);
                if (path.endsWith(".txt")) {
                    this.loadResources(ResourceLoader.getContent(path).split("[\r\n]+"));
                } else {
                    this.loadResources(new String[]{path});
                }
            } else {
                logger.info("Loading files from: " + path);
                File file = new File(path);
                this.loadFiles(new File[]{file});
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
    }

    @Inject
    public ContainerConfig(@Named(value="containers.default") String containers) throws GadgetException {
        if (containers != null) {
            this.loadContainers(containers);
        }
    }
}

