/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.gadgets.RemoteContentFetcherFactory;
import org.apache.shindig.gadgets.SigningFetcherFactory;
import org.apache.shindig.gadgets.oauth.OAuthFetcherFactory;
import org.apache.shindig.gadgets.oauth.OAuthRequestParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentFetcherFactory
implements Provider<ContentFetcher> {
    private final RemoteContentFetcherFactory remoteContentFetcherFactory;
    private final SigningFetcherFactory signingFetcherFactory;
    private final OAuthFetcherFactory oauthFetcherFactory;

    @Inject
    public ContentFetcherFactory(RemoteContentFetcherFactory remoteContentFetcherFactory, SigningFetcherFactory signingFetcherFactory, OAuthFetcherFactory oauthFetcherFactory) {
        this.signingFetcherFactory = signingFetcherFactory;
        this.remoteContentFetcherFactory = remoteContentFetcherFactory;
        this.oauthFetcherFactory = oauthFetcherFactory;
    }

    public ContentFetcher getSigningFetcher(GadgetToken token) throws GadgetException {
        return this.signingFetcherFactory.getSigningFetcher(this.remoteContentFetcherFactory.get(), token);
    }

    public ContentFetcher getOAuthFetcher(GadgetToken token, OAuthRequestParams params) throws GadgetException {
        return this.oauthFetcherFactory.getOAuthFetcher(this.remoteContentFetcherFactory.get(), token, params);
    }

    public ContentFetcher get() {
        return this.remoteContentFetcherFactory.get();
    }
}

