/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.shindig.gadgets.BasicGadgetBlacklist;
import org.apache.shindig.gadgets.BasicRemoteContentFetcher;
import org.apache.shindig.gadgets.ContainerConfig;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.ContentFetcherFactory;
import org.apache.shindig.gadgets.GadgetBlacklist;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.GadgetServer;
import org.apache.shindig.gadgets.GadgetSpecFetcher;
import org.apache.shindig.gadgets.MessageBundleFetcher;
import org.apache.shindig.gadgets.RemoteContentFetcherFactory;
import org.apache.shindig.gadgets.SigningFetcherFactory;
import org.apache.shindig.gadgets.oauth.OAuthFetcherFactory;
import org.apache.shindig.util.ResourceLoader;

public class DefaultGuiceModule
extends AbstractModule {
    private final Properties properties;
    private static final String DEFAULT_PROPERTIES = "gadgets.properties";

    protected void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.properties);
        this.bind(RemoteContentFetcherFactory.class);
        this.bind(SigningFetcherFactory.class);
        this.bind(ContentFetcher.class).annotatedWith(OAuthFetcherFactory.OAuthConfigFetcher.class).to(BasicRemoteContentFetcher.class);
        this.bind(OAuthFetcherFactory.class);
        this.bind(ContentFetcherFactory.class);
        this.bind(ContentFetcher.class).annotatedWith(GadgetSpecFetcher.class).toProvider(ContentFetcherFactory.class);
        this.bind(ContentFetcher.class).annotatedWith(MessageBundleFetcher.class).toProvider(ContentFetcherFactory.class);
        this.bind(GadgetBlacklist.class).to(BasicGadgetBlacklist.class);
        this.bind(Executor.class).toInstance((Object)Executors.newCachedThreadPool());
        this.bind(ContainerConfig.class).in(Scopes.SINGLETON);
        this.bind(GadgetFeatureRegistry.class).in(Scopes.SINGLETON);
        this.bind(GadgetServer.class).in(Scopes.SINGLETON);
    }

    public DefaultGuiceModule(Properties properties) {
        this.properties = properties;
    }

    public DefaultGuiceModule() {
        Properties properties = null;
        try {
            InputStream is = ResourceLoader.openResource(DEFAULT_PROPERTIES);
            properties = new Properties();
            properties.load(is);
        }
        catch (IOException e) {
            throw new CreationException(Arrays.asList(new Message("Unable to load properties: gadgets.properties")));
        }
        this.properties = properties;
    }
}

