/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FeatureTask
implements Callable<GadgetException> {
    private final Set<String> dependencies;
    private final String name;
    private final GadgetFeature feature;
    private final Gadget gadget;
    private final GadgetContext context;
    private boolean done = false;

    public boolean depsDone(Set<String> deps) {
        return deps.containsAll(this.dependencies);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public GadgetException call() {
        try {
            this.feature.process(this.gadget, this.context);
            this.done = true;
            return null;
        }
        catch (GadgetException e) {
            return e;
        }
        catch (Exception e) {
            return new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public FeatureTask(String name, GadgetFeature feature, Gadget gadget, GadgetContext context, Set<String> dependencies) {
        this.name = name;
        this.feature = feature;
        this.gadget = gadget;
        this.context = context;
        this.dependencies = dependencies;
    }
}

