/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeatureFactory;
import org.apache.shindig.gadgets.JsFeatureLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetFeatureRegistry {
    private final Map<String, Entry> features;
    private final Map<String, Entry> core;
    private final Map<Set<String>, Set<Entry>> transitiveDeps = new HashMap<Set<String>, Set<Entry>>();
    private boolean graphComplete = false;
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");

    @Inject
    public GadgetFeatureRegistry(@Named(value="features.default") String featureFiles, ContentFetcher contentFetcher) throws GadgetException {
        this.features = new HashMap<String, Entry>();
        this.core = new HashMap<String, Entry>();
        if (featureFiles != null) {
            JsFeatureLoader loader = new JsFeatureLoader(contentFetcher);
            loader.loadFeatures(featureFiles, this);
        }
    }

    public Entry register(String name, List<String> deps, GadgetFeatureFactory feature) {
        if (this.graphComplete) {
            throw new IllegalStateException("registerFeatures should never be invoked after calling getIncludedFeatures");
        }
        logger.info("Registering feature: " + name + " with deps " + deps);
        Entry entry = new Entry(name, deps, feature, this);
        if (this.isCore(entry)) {
            this.core.put(name, entry);
            for (Entry e : this.features.values()) {
                e.deps.add(name);
            }
        } else {
            entry.deps.addAll(this.core.keySet());
        }
        this.features.put(name, entry);
        return entry;
    }

    private boolean isCore(Entry entry) {
        return entry.name.startsWith("core") || entry.name.equals("core");
    }

    public Map<String, Entry> getAllFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    public boolean getIncludedFeatures(Set<String> needed, Set<Entry> resultsFound, Set<String> resultsMissing) {
        this.graphComplete = true;
        if (needed.size() == 0) {
            resultsFound.addAll(this.core.values());
            return true;
        }
        Set<Entry> cache = this.transitiveDeps.get(needed);
        if (cache != null) {
            resultsFound.addAll(cache);
            return true;
        }
        resultsFound.addAll(this.core.values());
        for (String featureName : needed) {
            Entry entry = this.features.get(featureName);
            if (entry == null) {
                resultsMissing.add(featureName);
                continue;
            }
            this.addEntryToSet(resultsFound, entry);
        }
        if (resultsMissing.size() == 0) {
            this.transitiveDeps.put(Collections.unmodifiableSet(new HashSet<String>(needed)), Collections.unmodifiableSet(new HashSet<Entry>(resultsFound)));
            return true;
        }
        return false;
    }

    private void addEntryToSet(Set<Entry> results, Entry entry) {
        for (String dep : entry.deps) {
            this.addEntryToSet(results, this.features.get(dep));
        }
        results.add(entry);
    }

    Entry getEntry(String name) {
        return this.features.get(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry {
        private final String name;
        private final Set<String> deps;
        private final Set<String> readDeps;
        private final GadgetFeatureFactory feature;

        private Entry(String name, List<String> deps, GadgetFeatureFactory feature, GadgetFeatureRegistry registry) throws IllegalStateException {
            this.name = name;
            this.deps = new HashSet<String>();
            this.readDeps = Collections.unmodifiableSet(this.deps);
            if (deps != null) {
                this.deps.addAll(deps);
            }
            this.feature = feature;
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getDependencies() {
            return this.readDeps;
        }

        public boolean equals(Object rhs) {
            if (rhs == this) {
                return true;
            }
            if (rhs instanceof Entry) {
                Entry entry = (Entry)rhs;
                return this.name.equals(entry.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public GadgetFeatureFactory getFeature() {
            return this.feature;
        }
    }
}

