/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.apache.shindig.gadgets.BidiSubstituter;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.ContentFetcherFactory;
import org.apache.shindig.gadgets.FeatureTask;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetBlacklist;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.GadgetSpecFetcher;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.MessageBundleFetcher;
import org.apache.shindig.gadgets.PreloadTask;
import org.apache.shindig.gadgets.RemoteContent;
import org.apache.shindig.gadgets.RemoteContentRequest;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.Substitutions;
import org.apache.shindig.gadgets.UserPrefSubstituter;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.spec.Preload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetServer {
    private final Executor executor;
    private final GadgetFeatureRegistry registry;
    private final GadgetBlacklist blacklist;
    private ContentFetcherFactory preloadFetcherFactory;
    private ContentFetcher gadgetSpecFetcher;
    private ContentFetcher messageBundleFetcher;

    @Inject
    public GadgetServer(Executor executor, GadgetFeatureRegistry registry, GadgetBlacklist blacklist, ContentFetcherFactory preloadFetcherFactory, @GadgetSpecFetcher ContentFetcher gadgetSpecFetcher, @MessageBundleFetcher ContentFetcher messageBundleFetcher) {
        this.executor = executor;
        this.registry = registry;
        this.blacklist = blacklist;
        this.preloadFetcherFactory = preloadFetcherFactory;
        this.gadgetSpecFetcher = gadgetSpecFetcher;
        this.messageBundleFetcher = messageBundleFetcher;
    }

    public Gadget processGadget(GadgetContext context) throws GadgetException {
        if (this.blacklist.isBlacklisted(context.getUrl())) {
            throw new GadgetException(GadgetException.Code.BLACKLISTED_GADGET);
        }
        RemoteContentRequest request = RemoteContentRequest.getRequest(context.getUrl(), context.getIgnoreCache());
        RemoteContent response = this.gadgetSpecFetcher.fetch(request);
        GadgetSpec spec = new GadgetSpec(context.getUrl(), response.getResponseAsString());
        return this.createGadgetFromSpec(spec, context);
    }

    private MessageBundle getBundle(LocaleSpec localeSpec, GadgetContext context) throws GadgetException {
        RemoteContentRequest request = RemoteContentRequest.getRequest(localeSpec.getMessages(), context.getIgnoreCache());
        RemoteContent response = this.messageBundleFetcher.fetch(request);
        MessageBundle bundle = new MessageBundle(response.getResponseAsString());
        return bundle;
    }

    private Gadget createGadgetFromSpec(GadgetSpec spec, GadgetContext context) throws GadgetException {
        String dir;
        MessageBundle bundle;
        LocaleSpec localeSpec = spec.getModulePrefs().getLocale(context.getLocale());
        if (localeSpec == null) {
            bundle = MessageBundle.EMPTY;
            dir = "ltr";
        } else {
            bundle = localeSpec.getMessages() != null && localeSpec.getMessages().toString().length() > 0 ? this.getBundle(localeSpec, context) : MessageBundle.EMPTY;
            dir = localeSpec.getLanguageDirection();
        }
        Substitutions substituter = new Substitutions();
        substituter.addSubstitutions(Substitutions.Type.MESSAGE, bundle.getMessages());
        BidiSubstituter.addSubstitutions(substituter, dir);
        substituter.addSubstitution(Substitutions.Type.MODULE, "ID", Integer.toString(context.getModuleId()));
        UserPrefSubstituter.addSubstitutions(substituter, spec, context.getUserPrefs());
        spec = spec.substitute(substituter);
        Set<GadgetFeatureRegistry.Entry> features = this.getFeatures(spec);
        LinkedList<JsLibrary> jsLibraries = new LinkedList<JsLibrary>();
        HashSet<String> done = new HashSet<String>(features.size());
        HashMap<GadgetFeatureRegistry.Entry, GadgetFeature> tasks = new HashMap<GadgetFeatureRegistry.Entry, GadgetFeature>();
        do {
            for (GadgetFeatureRegistry.Entry entry : features) {
                if (done.contains(entry.getName()) || !done.containsAll(entry.getDependencies())) continue;
                GadgetFeature feature = entry.getFeature().create();
                jsLibraries.addAll(feature.getJsLibraries(context));
                if (!feature.isJsOnly()) {
                    tasks.put(entry, feature);
                }
                done.add(entry.getName());
            }
        } while (done.size() != features.size());
        Gadget gadget = new Gadget(context, spec, bundle, jsLibraries);
        this.runTasks(gadget, tasks);
        return gadget;
    }

    private void runTasks(Gadget gadget, Map<GadgetFeatureRegistry.Entry, GadgetFeature> tasks) throws GadgetException {
        RenderingContext renderContext = gadget.getContext().getRenderingContext();
        if (RenderingContext.GADGET.equals((Object)renderContext)) {
            ExecutorCompletionService<RemoteContent> preloadProcessor = new ExecutorCompletionService<RemoteContent>(this.executor);
            for (Preload preload : gadget.getSpec().getModulePrefs().getPreloads()) {
                PreloadTask task = new PreloadTask(gadget.getContext(), preload, this.preloadFetcherFactory);
                Future<RemoteContent> future = preloadProcessor.submit(task);
                gadget.getPreloadMap().put(preload, future);
            }
        }
        ExecutorCompletionService<GadgetException> featureProcessor = new ExecutorCompletionService<GadgetException>(this.executor);
        GadgetContext context = gadget.getContext();
        HashSet<FeatureTask> pending = new HashSet<FeatureTask>();
        for (Map.Entry<GadgetFeatureRegistry.Entry, GadgetFeature> entry : tasks.entrySet()) {
            FeatureTask task = new FeatureTask(entry.getKey().getName(), entry.getValue(), gadget, context, entry.getKey().getDependencies());
            pending.add(task);
        }
        HashSet<FeatureTask> running = new HashSet<FeatureTask>();
        HashSet<String> done = new HashSet<String>();
        do {
            for (FeatureTask task : pending) {
                if (!task.depsDone(done)) continue;
                pending.remove(task);
                running.add(task);
                featureProcessor.submit(task);
            }
            if (running.size() > 0) {
                try {
                    Future future;
                    while ((future = featureProcessor.take()) != null) {
                        GadgetException e = (GadgetException)future.get();
                        if (future.get() == null) continue;
                        throw (GadgetException)future.get();
                    }
                }
                catch (Exception e) {
                    throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
                }
            }
            for (FeatureTask task : running) {
                if (!task.isDone()) continue;
                done.add(task.getName());
                running.remove(task);
            }
        } while (pending.size() > 0 || running.size() > 0);
    }

    private Set<GadgetFeatureRegistry.Entry> getFeatures(GadgetSpec spec) throws GadgetException {
        Map<String, Feature> features = spec.getModulePrefs().getFeatures();
        HashSet<GadgetFeatureRegistry.Entry> dependencies = new HashSet<GadgetFeatureRegistry.Entry>(features.size());
        HashSet<String> unsupported = new HashSet<String>();
        this.registry.getIncludedFeatures(features.keySet(), dependencies, unsupported);
        for (String missing : unsupported) {
            Feature feature = features.get(missing);
            if (!feature.getRequired()) continue;
            throw new GadgetException(GadgetException.Code.UNSUPPORTED_FEATURE, missing);
        }
        return dependencies;
    }
}

