/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.JsLibraryFeatureFactory;
import org.apache.shindig.gadgets.ParsedFeature;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.util.ResourceLoader;
import org.apache.shindig.util.XmlException;
import org.apache.shindig.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsFeatureLoader {
    private final ContentFetcher fetcher;
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");

    public void loadFeatures(String path, GadgetFeatureRegistry registry) throws GadgetException {
        LinkedList<ParsedFeature> features = new LinkedList<ParsedFeature>();
        try {
            if (path.startsWith("res://")) {
                path = path.substring(6);
                logger.info("Loading resources from: " + path);
                if (path.endsWith(".txt")) {
                    this.loadResources(ResourceLoader.getContent(path).split("[\r\n]+"), features);
                } else {
                    this.loadResources(new String[]{path}, features);
                }
            } else {
                logger.info("Loading files from: " + path);
                File file = new File(path);
                this.loadFiles(new File[]{file}, features);
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
        for (ParsedFeature feature : features) {
            JsLibraryFeatureFactory factory = new JsLibraryFeatureFactory(feature.libraries);
            registry.register(feature.name, feature.deps, factory);
        }
    }

    public GadgetFeatureRegistry.Entry loadFeature(GadgetFeatureRegistry registry, String xml) throws GadgetException {
        ParsedFeature feature = this.parse(xml, "", false);
        JsLibraryFeatureFactory factory = new JsLibraryFeatureFactory(feature.libraries);
        return registry.register(feature.name, null, factory);
    }

    private void loadFiles(File[] files, List<ParsedFeature> features) throws GadgetException {
        for (File file : files) {
            ParsedFeature feature;
            if (file.isDirectory()) {
                this.loadFiles(file.listFiles(), features);
                continue;
            }
            if (!file.getName().endsWith(".xml") || (feature = this.processFile(file)) == null) continue;
            features.add(feature);
        }
    }

    private void loadResources(String[] paths, List<ParsedFeature> features) throws GadgetException {
        try {
            for (String file : paths) {
                logger.info("Processing resource: " + file);
                String content = ResourceLoader.getContent(file);
                String parent = file.substring(0, file.lastIndexOf(47) + 1);
                ParsedFeature feature = this.parse(content, parent, true);
                if (feature != null) {
                    features.add(feature);
                    continue;
                }
                logger.warning("Failed to parse feature: " + file);
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
    }

    private ParsedFeature processFile(File file) {
        logger.info("Loading file: " + file.getName());
        ParsedFeature feature = null;
        if (file.canRead()) {
            try {
                feature = this.parse(ResourceLoader.getContent(file), file.getParent() + '/', false);
            }
            catch (IOException e) {
                logger.warning("Error reading file: " + file.getAbsolutePath());
            }
            catch (GadgetException e) {
                logger.warning("Failed parsing file: " + file.getAbsolutePath());
            }
        } else {
            logger.warning("Unable to read file: " + file.getAbsolutePath());
        }
        return feature;
    }

    private ParsedFeature parse(String xml, String path, boolean isResource) throws GadgetException {
        Element doc;
        try {
            doc = XmlUtil.parse(xml);
        }
        catch (XmlException e) {
            throw new GadgetException(GadgetException.Code.MALFORMED_XML_DOCUMENT, (Throwable)e);
        }
        ParsedFeature feature = new ParsedFeature();
        feature.basePath = path;
        feature.isResource = isResource;
        NodeList nameNode = doc.getElementsByTagName("name");
        if (nameNode.getLength() != 1) {
            throw new GadgetException(GadgetException.Code.MALFORMED_XML_DOCUMENT, "No name provided");
        }
        feature.name = nameNode.item(0).getTextContent();
        NodeList gadgets = doc.getElementsByTagName("gadget");
        int j = gadgets.getLength();
        for (int i = 0; i < j; ++i) {
            this.processContext(feature, (Element)gadgets.item(i), RenderingContext.GADGET);
        }
        NodeList containers = doc.getElementsByTagName("container");
        int j2 = containers.getLength();
        for (int i = 0; i < j2; ++i) {
            this.processContext(feature, (Element)containers.item(i), RenderingContext.CONTAINER);
        }
        NodeList dependencies = doc.getElementsByTagName("dependency");
        int j3 = dependencies.getLength();
        for (int i = 0; i < j3; ++i) {
            feature.deps.add(dependencies.item(i).getTextContent());
        }
        return feature;
    }

    private void processContext(ParsedFeature feature, Element context, RenderingContext renderingContext) throws GadgetException {
        String container = XmlUtil.getAttribute(context, "container", "default");
        NodeList libraries = context.getElementsByTagName("script");
        int j = libraries.getLength();
        for (int i = 0; i < j; ++i) {
            String content;
            JsLibrary.Type type;
            Element script = (Element)libraries.item(i);
            boolean inlineOk = XmlUtil.getBoolAttribute(script, "inline", true);
            String source = XmlUtil.getAttribute(script, "src");
            if (source == null) {
                type = JsLibrary.Type.INLINE;
                content = script.getTextContent();
            } else {
                content = source;
                if (content.startsWith("http://")) {
                    type = JsLibrary.Type.URL;
                } else if (content.startsWith("//")) {
                    type = JsLibrary.Type.URL;
                    content = content.substring(1);
                } else if (content.startsWith("res://")) {
                    content = content.substring(6);
                    type = JsLibrary.Type.RESOURCE;
                } else if (feature.isResource) {
                    content = feature.basePath + content;
                    type = JsLibrary.Type.RESOURCE;
                } else {
                    content = feature.basePath + content;
                    type = JsLibrary.Type.FILE;
                }
            }
            JsLibrary library = JsLibrary.create(type, content, feature.name, inlineOk ? this.fetcher : null);
            for (String cont : container.split(",")) {
                feature.addLibrary(renderingContext, cont.trim(), library);
            }
        }
    }

    public JsFeatureLoader(ContentFetcher fetcher) {
        this.fetcher = fetcher;
    }
}

