/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.RenderingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsLibraryFeature
extends GadgetFeature {
    final Map<RenderingContext, Map<String, List<JsLibrary>>> libraries;

    public JsLibraryFeature(Map<RenderingContext, Map<String, List<JsLibrary>>> libraries) {
        this.libraries = Collections.unmodifiableMap(libraries);
    }

    @Override
    public List<JsLibrary> getJsLibraries(GadgetContext context) {
        List<JsLibrary> libs = null;
        if (context == null) {
            libs = new LinkedList<JsLibrary>();
            for (Map.Entry<RenderingContext, Map<String, List<JsLibrary>>> i : this.libraries.entrySet()) {
                for (Map.Entry<String, List<JsLibrary>> e : i.getValue().entrySet()) {
                    libs.addAll((Collection<JsLibrary>)e.getValue());
                }
            }
        } else {
            Map<String, List<JsLibrary>> contextLibs = this.libraries.get((Object)context.getRenderingContext());
            if (contextLibs != null && (libs = contextLibs.get(context.getContainer())) == null) {
                libs = contextLibs.get("default");
            }
        }
        if (libs == null) {
            return Collections.emptyList();
        }
        return libs;
    }

    @Override
    public boolean isJsOnly() {
        return true;
    }
}

