/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.concurrent.Callable;
import org.apache.shindig.gadgets.ContentFetcherFactory;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.RemoteContent;
import org.apache.shindig.gadgets.RemoteContentRequest;
import org.apache.shindig.gadgets.spec.Preload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PreloadTask
implements Callable<RemoteContent> {
    private final Preload preload;
    private final ContentFetcherFactory preloadFetcherFactory;
    private final GadgetContext context;

    @Override
    public RemoteContent call() {
        RemoteContentRequest request = new RemoteContentRequest(this.preload.getHref());
        try {
            switch (this.preload.getAuth()) {
                case NONE: {
                    return this.preloadFetcherFactory.get().fetch(request);
                }
                case SIGNED: {
                    return this.preloadFetcherFactory.getSigningFetcher(this.context.getToken()).fetch(request);
                }
            }
            return RemoteContent.ERROR;
        }
        catch (GadgetException e) {
            return RemoteContent.ERROR;
        }
    }

    public PreloadTask(GadgetContext context, Preload preload, ContentFetcherFactory preloadFetcherFactory) {
        this.preload = preload;
        this.preloadFetcherFactory = preloadFetcherFactory;
        this.context = context;
    }
}

