/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteContent {
    public static final int SC_OK = 200;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    private final int httpStatusCode;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final String encoding;
    public static final RemoteContent ERROR = new RemoteContent(500);
    public static final RemoteContent NOT_FOUND = new RemoteContent(404);
    private String responseString = null;
    private final byte[] responseBytes;
    private final Map<String, List<String>> headers;
    private final Map<String, String> metadata;

    private RemoteContent(int statusCode) {
        this.httpStatusCode = statusCode;
        this.responseBytes = new byte[0];
        this.encoding = DEFAULT_ENCODING;
        this.headers = Collections.emptyMap();
        this.metadata = new HashMap<String, String>();
    }

    public RemoteContent(int httpStatusCode, byte[] responseBytes, Map<String, List<String>> headers) {
        this.httpStatusCode = httpStatusCode;
        if (responseBytes == null) {
            this.responseBytes = new byte[0];
        } else {
            this.responseBytes = new byte[responseBytes.length];
            System.arraycopy(responseBytes, 0, this.responseBytes, 0, responseBytes.length);
        }
        if (headers == null) {
            this.headers = Collections.emptyMap();
        } else {
            HashMap<String, List<String>> tmpHeaders = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                ArrayList newList = new ArrayList(entry.getValue());
                tmpHeaders.put(entry.getKey(), Collections.unmodifiableList(newList));
            }
            this.headers = tmpHeaders;
        }
        this.metadata = new HashMap<String, String>();
        this.encoding = this.detectEncoding();
    }

    public RemoteContent(String body) {
        this(200, body.getBytes(), null);
    }

    private String detectEncoding() {
        int offset;
        String[] parts;
        String contentType = this.getHeader("Content-Type");
        if (contentType != null && (parts = contentType.split(";")).length == 2 && (offset = parts[1].indexOf("charset=")) != -1) {
            return parts[1].substring(offset + 8);
        }
        return DEFAULT_ENCODING;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public InputStream getResponse() {
        return new ByteArrayInputStream(this.responseBytes);
    }

    public String getResponseAsString() {
        if (this.responseString == null) {
            try {
                String response = new String(this.responseBytes, this.encoding);
                this.responseString = response.length() > 0 && response.codePointAt(0) == 65279 ? response.substring(1) : response;
            }
            catch (UnsupportedEncodingException e) {
                this.responseString = "Unable to convert from encoding: " + this.encoding;
            }
        }
        return this.responseString;
    }

    public Map<String, List<String>> getAllHeaders() {
        return this.headers;
    }

    public List<String> getHeaders(String name) {
        List<String> ret = this.headers.get(name);
        if (ret == null) {
            return Collections.emptyList();
        }
        return ret;
    }

    public String getHeader(String name) {
        List<String> headerList = this.getHeaders(name);
        if (headerList.size() == 0) {
            return null;
        }
        return headerList.get(0);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

