/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteContentRequest {
    private final byte[] postBody;
    private final String contentType;
    public static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=utf-8";
    private final Map<String, List<String>> headers;
    private final String method;
    private final URI uri;
    private final Options options;
    public static final Options DEFAULT_OPTIONS = new Options();
    public static final Options IGNORE_CACHE_OPTIONS = new Options();

    public InputStream getPostBody() {
        return new ByteArrayInputStream(this.postBody);
    }

    public String getPostBodyAsString() {
        try {
            return new String(this.postBody, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public int getPostBodyLength() {
        return this.postBody.length;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, List<String>> getAllHeaders() {
        return this.headers;
    }

    public List<String> getHeaders(String name) {
        List<String> match = this.headers.get(name);
        if (match == null) {
            return Collections.emptyList();
        }
        return match;
    }

    public String getHeader(String name) {
        List<String> headerList = this.getHeaders(name);
        if (headerList.size() == 0) {
            return null;
        }
        return headerList.get(0);
    }

    public String getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public Options getOptions() {
        return this.options;
    }

    public static RemoteContentRequest getRequest(URI uri, boolean ignoreCache) {
        Options options = new Options();
        options.ignoreCache = ignoreCache;
        return new RemoteContentRequest(uri, options);
    }

    public RemoteContentRequest(String method, URI uri, Map<String, List<String>> headers, byte[] postBody, Options options) {
        this.method = method;
        this.uri = uri;
        this.options = options == null ? new Options() : options;
        if (headers == null) {
            this.headers = Collections.emptyMap();
        } else {
            boolean setPragmaHeader = false;
            HashMap tmpHeaders = new HashMap();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                ArrayList<String> newList = new ArrayList<String>((Collection)entry.getValue());
                if (entry.getKey().equals("Pragma") && options.ignoreCache) {
                    newList.add("no-cache");
                    setPragmaHeader = true;
                }
                tmpHeaders.put(entry.getKey(), Collections.unmodifiableList(newList));
            }
            if (!setPragmaHeader && options.ignoreCache) {
                tmpHeaders.put("Pragma", Arrays.asList("no-cache"));
            }
            this.headers = Collections.unmodifiableMap(tmpHeaders);
        }
        if (postBody == null) {
            this.postBody = new byte[0];
        } else {
            this.postBody = new byte[postBody.length];
            System.arraycopy(postBody, 0, this.postBody, 0, postBody.length);
        }
        String type = this.getHeader("Content-Type");
        this.contentType = type == null ? DEFAULT_CONTENT_TYPE : type;
    }

    public RemoteContentRequest(URI uri, RemoteContentRequest base) {
        this.uri = uri;
        this.method = base.method;
        this.options = base.options;
        this.headers = base.headers;
        this.contentType = base.contentType;
        this.postBody = base.postBody;
    }

    public RemoteContentRequest(URI uri) {
        this("GET", uri, null, null, DEFAULT_OPTIONS);
    }

    public RemoteContentRequest(URI uri, Options options) {
        this("GET", uri, null, null, options);
    }

    public RemoteContentRequest(URI uri, Map<String, List<String>> headers) {
        this("GET", uri, headers, null, DEFAULT_OPTIONS);
    }

    public RemoteContentRequest(URI uri, Map<String, List<String>> headers, Options options) {
        this("GET", uri, headers, null, options);
    }

    public RemoteContentRequest(URI uri, byte[] postBody) {
        this("POST", uri, null, postBody, DEFAULT_OPTIONS);
    }

    public RemoteContentRequest(URI uri, byte[] postBody, Options options) {
        this("POST", uri, null, postBody, options);
    }

    public RemoteContentRequest(URI uri, Map<String, List<String>> headers, byte[] postBody) {
        this("POST", uri, headers, postBody, DEFAULT_OPTIONS);
    }

    public RemoteContentRequest(URI uri, Map<String, List<String>> headers, byte[] postBody, Options options) {
        this("POST", uri, headers, postBody, options);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.method).append(' ').append(this.uri.getPath()).append(" HTTP/1.1\r\n").append("Host: ").append(this.uri.getHost()).append(this.uri.getPort() == 80 ? "" : ":" + this.uri.getPort()).append("\r\n");
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            buf.append(entry.getKey()).append(": ");
            boolean first = false;
            for (String header : entry.getValue()) {
                if (!first) {
                    first = true;
                } else {
                    buf.append(", ");
                }
                buf.append(header);
            }
            buf.append("\r\n");
        }
        buf.append("\r\n");
        buf.append(new String(this.postBody));
        return buf.toString();
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs instanceof RemoteContentRequest) {
            RemoteContentRequest req = (RemoteContentRequest)rhs;
            return this.method.equals(req.method) && this.uri.equals(req.uri) && Arrays.equals(this.postBody, req.postBody) && ((Object)this.headers).equals(req.headers);
        }
        return false;
    }

    static {
        RemoteContentRequest.IGNORE_CACHE_OPTIONS.ignoreCache = true;
    }

    public static class Options {
        public boolean ignoreCache = false;
    }
}

