/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import org.apache.shindig.gadgets.ChainedContentFetcher;
import org.apache.shindig.gadgets.ContentCache;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.gadgets.RemoteContent;
import org.apache.shindig.gadgets.RemoteContentRequest;
import org.apache.shindig.util.Crypto;
import org.apache.shindig.util.TimeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigningFetcher
extends ChainedContentFetcher {
    protected static final String OPENSOCIAL_OWNERID = "opensocial_owner_id";
    protected static final String OPENSOCIAL_VIEWERID = "opensocial_viewer_id";
    protected static final String OPENSOCIAL_APPID = "opensocial_app_id";
    protected static final String XOAUTH_PUBLIC_KEY = "xoauth_signature_publickey";
    protected static final Pattern ALLOWED_PARAM_NAME = Pattern.compile("[-:\\w]+");
    protected final TimeSource clock = new TimeSource();
    protected final GadgetToken authToken;
    protected final Object privateKeyObject;
    protected final String keyName;
    protected final ContentCache cache;

    protected SigningFetcher(ContentCache cache, ContentFetcher next, GadgetToken authToken) {
        this(cache, next, authToken, null, null);
    }

    public static SigningFetcher makeFromPrivateKey(ContentCache cache, ContentFetcher next, GadgetToken authToken, String keyName, PrivateKey privateKey) {
        return new SigningFetcher(cache, next, authToken, keyName, privateKey);
    }

    public static SigningFetcher makeFromB64PrivateKey(ContentCache cache, ContentFetcher next, GadgetToken authToken, String keyName, String privateKey) {
        return new SigningFetcher(cache, next, authToken, keyName, privateKey);
    }

    public static SigningFetcher makeFromPrivateKeyBytes(ContentCache cache, ContentFetcher next, GadgetToken authToken, String keyName, byte[] privateKey) {
        return new SigningFetcher(cache, next, authToken, keyName, privateKey);
    }

    protected SigningFetcher(ContentCache cache, ContentFetcher next, GadgetToken authToken, String keyName, Object privateKeyObject) {
        super(next);
        this.cache = cache;
        this.authToken = authToken;
        this.keyName = keyName;
        this.privateKeyObject = privateKeyObject;
    }

    @Override
    public RemoteContent fetch(RemoteContentRequest request) throws GadgetException {
        try {
            RemoteContentRequest cacheableRequest = this.makeCacheableRequest(request);
            RemoteContent result = this.cache.getContent(cacheableRequest);
            if (result != null) {
                return result;
            }
            RemoteContentRequest signedRequest = this.signRequest(request);
            signedRequest.getOptions().ignoreCache = true;
            result = this.nextFetcher.fetch(signedRequest);
            this.cache.addContent(cacheableRequest, result);
            return result;
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private RemoteContentRequest makeCacheableRequest(RemoteContentRequest request) throws IOException, URISyntaxException {
        URI resource = request.getUri();
        String query = resource.getRawQuery();
        List<OAuth.Parameter> cacheableParams = this.sanitize(OAuth.decodeForm((String)query));
        this.addOpenSocialParams(cacheableParams);
        this.addOAuthNonTemporalParams(cacheableParams);
        String cacheableQuery = OAuth.formEncode(cacheableParams);
        URL url = new URL(resource.getScheme(), resource.getHost(), resource.getPort(), resource.getRawPath() + "?" + cacheableQuery);
        RemoteContentRequest cacheableRequest = new RemoteContentRequest(url.toURI(), request);
        return cacheableRequest;
    }

    private RemoteContentRequest signRequest(RemoteContentRequest req) throws GadgetException {
        try {
            URI resource = req.getUri();
            String query = resource.getRawQuery();
            resource = this.removeQuery(resource);
            List<OAuth.Parameter> queryParams = this.sanitize(OAuth.decodeForm((String)query));
            String postStr = req.getPostBodyAsString();
            List<OAuth.Parameter> postParams = this.sanitize(OAuth.decodeForm((String)postStr));
            ArrayList<OAuth.Parameter> msgParams = new ArrayList<OAuth.Parameter>();
            msgParams.addAll(queryParams);
            msgParams.addAll(postParams);
            this.addOpenSocialParams(msgParams);
            this.addOAuthParams(msgParams);
            OAuthMessage message = new OAuthMessage(req.getMethod(), resource.toString(), msgParams);
            this.signMessage(message);
            HashSet<String> forPost = new HashSet<String>();
            for (OAuth.Parameter param : postParams) {
                forPost.add(param.getKey());
            }
            ArrayList<Map.Entry> newQuery = new ArrayList<Map.Entry>();
            for (Map.Entry param : message.getParameters()) {
                if (forPost.contains(param.getKey())) continue;
                newQuery.add(param);
            }
            String finalQuery = OAuth.formEncode(newQuery);
            URL url = new URL(resource.getScheme(), resource.getHost(), resource.getPort(), resource.getRawPath() + "?" + finalQuery);
            return new RemoteContentRequest(url.toURI(), req);
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private URI removeQuery(URI resource) throws URISyntaxException {
        return new URI(resource.getScheme(), null, resource.getHost(), resource.getPort(), resource.getRawPath(), null, null);
    }

    private void addOpenSocialParams(List<OAuth.Parameter> msgParams) {
        String app;
        String viewer;
        String owner = this.authToken.getOwnerId();
        if (owner != null) {
            msgParams.add(new OAuth.Parameter(OPENSOCIAL_OWNERID, owner));
        }
        if ((viewer = this.authToken.getViewerId()) != null) {
            msgParams.add(new OAuth.Parameter(OPENSOCIAL_VIEWERID, viewer));
        }
        if ((app = this.authToken.getAppId()) != null) {
            msgParams.add(new OAuth.Parameter(OPENSOCIAL_APPID, app));
        }
    }

    private void addOAuthParams(List<OAuth.Parameter> msgParams) {
        this.addOAuthNonTemporalParams(msgParams);
        String nonce = Long.toHexString(Crypto.rand.nextLong());
        msgParams.add(new OAuth.Parameter("oauth_nonce", nonce));
        String timestamp = Long.toString(this.clock.currentTimeMillis() / 1000L);
        msgParams.add(new OAuth.Parameter("oauth_timestamp", timestamp));
    }

    private void addOAuthNonTemporalParams(List<OAuth.Parameter> msgParams) {
        msgParams.add(new OAuth.Parameter("oauth_token", ""));
        String domain = this.authToken.getDomain();
        if (domain != null) {
            msgParams.add(new OAuth.Parameter("oauth_consumer_key", domain));
        }
        if (this.keyName != null) {
            msgParams.add(new OAuth.Parameter(XOAUTH_PUBLIC_KEY, this.keyName));
        }
        msgParams.add(new OAuth.Parameter("oauth_signature_method", "RSA-SHA1"));
    }

    protected void signMessage(OAuthMessage message) throws Exception {
        OAuthConsumer consumer = new OAuthConsumer(null, null, null, null);
        consumer.setProperty("RSA-SHA1.PrivateKey", this.privateKeyObject);
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        message.sign(accessor);
    }

    private List<OAuth.Parameter> sanitize(List<OAuth.Parameter> params) {
        ArrayList<OAuth.Parameter> list = new ArrayList<OAuth.Parameter>();
        for (OAuth.Parameter p : params) {
            if (!this.allowParam(p.getKey())) continue;
            list.add(p);
        }
        return list;
    }

    private boolean allowParam(String paramName) {
        String canonParamName = paramName.toLowerCase();
        return !canonParamName.startsWith("oauth") && !canonParamName.startsWith("xoauth") && !canonParamName.startsWith("opensocial") && ALLOWED_PARAM_NAME.matcher(canonParamName).matches();
    }
}

