/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import org.apache.shindig.gadgets.ContentCache;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.gadgets.SigningFetcher;
import org.apache.shindig.util.InputStreamConsumer;
import org.apache.shindig.util.ResourceLoader;

public class SigningFetcherFactory {
    private final ContentCache cache;
    private final String keyName;
    private final String privateKey;

    public ContentFetcher getSigningFetcher(ContentFetcher networkFetcher, GadgetToken token) throws GadgetException {
        return SigningFetcher.makeFromB64PrivateKey(this.cache, networkFetcher, token, this.keyName, this.privateKey);
    }

    protected SigningFetcherFactory(ContentCache cache) {
        this.cache = cache;
        this.keyName = null;
        this.privateKey = null;
    }

    @Inject
    public SigningFetcherFactory(ContentCache cache, @Named(value="signing.key-name") String keyName, @Named(value="signing.key-file") String keyFile) {
        this.cache = cache;
        this.keyName = keyName == null || keyName.length() == 0 ? null : keyName;
        String privateKey = null;
        try {
            privateKey = InputStreamConsumer.readToString(ResourceLoader.open(keyFile));
        }
        catch (IOException e) {
            privateKey = "";
        }
        this.privateKey = privateKey;
    }
}

