/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Substitutions {
    private Map<Type, Map<String, String>> substitutions = new EnumMap<Type, Map<String, String>>(Type.class);

    public Substitutions() {
        for (Type type : Type.values()) {
            this.substitutions.put(type, new HashMap());
        }
    }

    public void addSubstitution(Type type, String key, String value) {
        this.substitutions.get((Object)type).put(key, value);
    }

    public void addSubstitutions(Type type, Map<String, String> entries) {
        this.substitutions.get((Object)type).putAll(entries);
    }

    public String getSubstitution(Type type, String name) {
        return this.substitutions.get((Object)type).get(name);
    }

    public String substituteString(Type type, String input) {
        if (input == null) {
            return null;
        }
        if (type == null) {
            for (Type t : Type.values()) {
                input = this.substituteString(t, input);
            }
            return input;
        }
        if (this.substitutions.get((Object)type).size() == 0 || !input.contains(type.prefix)) {
            return input;
        }
        StringBuilder output = new StringBuilder();
        int j = input.length();
        for (int i = 0; i < j; ++i) {
            if (input.regionMatches(i, type.prefix, 0, type.prefix.length())) {
                int start = i + type.prefix.length();
                int end = input.indexOf("__", start);
                if (end != -1) {
                    String name = input.substring(start, end);
                    String replacement = this.substitutions.get((Object)type).get(name);
                    if (replacement != null) {
                        output.append(replacement);
                    } else {
                        output.append(input.substring(i, end + 2));
                    }
                    i = end + 1;
                    continue;
                }
                output.append(input.substring(i));
                break;
            }
            output.append(input.charAt(i));
        }
        return output.toString();
    }

    public URI substituteUri(Type type, URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI(this.substituteString(type, uri.toString()));
        }
        catch (URISyntaxException e) {
            return URI.create("");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        MESSAGE("MSG"),
        BIDI("BIDI"),
        USER_PREF("UP"),
        MODULE("MODULE");

        private String prefix;

        private Type(String prefix) {
            this.prefix = "__" + prefix + '_';
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

