/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.opensocial.DefaultGadgetRewriter;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.opensocial.UriCallback;
import com.google.caja.opensocial.UriCallbackException;
import com.google.caja.opensocial.UriCallbackOption;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import org.apache.shindig.gadgets.GadgetContentFilter;
import org.apache.shindig.gadgets.GadgetException;

public class CajaContentFilter
implements GadgetContentFilter {
    private final URI retrievedUri;

    public CajaContentFilter(URI retrievedUri) {
        this.retrievedUri = retrievedUri;
    }

    public String filter(String content) throws GadgetException {
        UriCallback cb = new UriCallback(){

            public UriCallbackOption getOption(ExternalReference externalReference, String string) {
                return UriCallbackOption.REWRITE;
            }

            public Reader retrieve(ExternalReference externalReference, String string) throws UriCallbackException {
                throw new UriCallbackException(externalReference);
            }

            public URI rewrite(ExternalReference externalReference, String string) {
                return externalReference.getUri();
            }
        };
        SimpleMessageQueue mq = new SimpleMessageQueue();
        DefaultGadgetRewriter rw = new DefaultGadgetRewriter((MessageQueue)mq);
        StringReader input = new StringReader(content);
        StringBuilder output = new StringBuilder();
        try {
            rw.rewriteContent(this.retrievedUri, (Readable)input, cb, (Appendable)output);
        }
        catch (GadgetRewriteException e) {
            this.throwCajolingException((Exception)((Object)e), (MessageQueue)mq);
        }
        catch (UriCallbackException e) {
            this.throwCajolingException((Exception)((Object)e), (MessageQueue)mq);
        }
        catch (IOException e) {
            this.throwCajolingException(e, (MessageQueue)mq);
        }
        return ((Object)output).toString();
    }

    private void throwCajolingException(Exception cause, MessageQueue mq) throws GadgetException {
        StringBuilder errbuilder = new StringBuilder();
        MessageContext mc = new MessageContext();
        ArrayList exceptions = new ArrayList();
        if (cause != null) {
            errbuilder.append(cause).append('\n');
        }
        for (Message m : mq.getMessages()) {
            errbuilder.append(m.format(mc)).append('\n');
        }
        throw new GadgetException(GadgetException.Code.MALFORMED_FOR_SAFE_INLINING, errbuilder.toString());
    }
}

