/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.gadgets.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContentFilter;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.GadgetServer;
import org.apache.shindig.gadgets.GadgetTokenDecoder;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.RemoteContent;
import org.apache.shindig.gadgets.http.CajaContentFilter;
import org.apache.shindig.gadgets.http.HttpGadgetContext;
import org.apache.shindig.gadgets.http.HttpUtil;
import org.apache.shindig.gadgets.http.UrlGenerator;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.Preload;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetRenderingTask {
    private static final String CAJA_PARAM = "caja";
    private static final String LIBS_PARAM_NAME = "libs";
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");
    public static final String STRICT_MODE_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private final GadgetServer server;
    private final GadgetFeatureRegistry registry;
    private final ContainerConfig containerConfig;
    private final UrlGenerator urlGenerator;
    private final GadgetTokenDecoder tokenDecoder;
    private GadgetContext context;
    private final List<GadgetContentFilter> filters;

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.request = request;
        this.response = response;
        this.context = new HttpGadgetContext(request, this.tokenDecoder);
        URI url = this.context.getUrl();
        if (url == null) {
            response.sendError(400, "Missing or malformed url parameter");
            return;
        }
        if (!"http".equals(url.getScheme()) && !"https".equals(url.getScheme())) {
            response.sendError(400, "Unsupported scheme (must be http or https).");
            return;
        }
        if (!this.validateParent()) {
            response.sendError(400, "Unsupported parent parameter. Check your container code.");
            return;
        }
        if (this.getUseCaja(request)) {
            this.filters.add(new CajaContentFilter(url));
        }
        try {
            Gadget gadget = this.server.processGadget(this.context);
            this.outputGadget(gadget);
        }
        catch (GadgetException e) {
            this.outputErrors(e);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unhandled exception ", e);
            this.outputErrors(new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "There was a problem rendering the gadget: " + e.getMessage()));
        }
    }

    private void outputGadget(Gadget gadget) throws IOException, GadgetException {
        String viewName = this.context.getView();
        View view = HttpUtil.getView(gadget, this.containerConfig);
        if (view == null) {
            throw new GadgetException(GadgetException.Code.UNKNOWN_VIEW_SPECIFIED, "No appropriate view could be found for this gadget");
        }
        switch (view.getType()) {
            case HTML: {
                this.outputHtmlGadget(gadget, view);
                break;
            }
            case URL: {
                this.outputUrlGadget(gadget, view);
            }
        }
    }

    private void outputHtmlGadget(Gadget gadget, View view) throws IOException, GadgetException {
        this.response.setContentType("text/html; charset=UTF-8");
        StringBuilder markup = new StringBuilder();
        if (!view.getQuirks()) {
            markup.append(STRICT_MODE_DOCTYPE);
        }
        String boilerPlate = "<html><head><style type=\"text/css\">body,td,div,span,p{font-family:arial,sans-serif;}a {color:#0000cc;}a:visited {color:#551a8b;}a:active {color:#ff0000;}body{margin: 0px;padding: 0px;background-color:white;}</style></head>";
        markup.append(boilerPlate);
        LocaleSpec localeSpec = gadget.getSpec().getModulePrefs().getLocale(gadget.getContext().getLocale());
        if (localeSpec == null) {
            markup.append("<body>");
        } else {
            markup.append("<body dir=\"").append(localeSpec.getLanguageDirection()).append("\">");
        }
        StringBuilder externJs = new StringBuilder();
        StringBuilder inlineJs = new StringBuilder();
        String externFmt = "<script src=\"%s\"></script>";
        String forcedLibs = this.request.getParameter(LIBS_PARAM_NAME);
        HashSet<String> libs = new HashSet<String>();
        if (forcedLibs != null) {
            if (forcedLibs.trim().length() == 0) {
                libs.add("core");
            } else {
                libs.addAll(Arrays.asList(forcedLibs.split(":")));
            }
        }
        if (libs.size() > 0) {
            String jsUrl = this.urlGenerator.getBundledJsUrl(libs, this.context);
            markup.append(String.format(externFmt, jsUrl));
            HashSet<GadgetFeatureRegistry.Entry> deps = new HashSet<GadgetFeatureRegistry.Entry>();
            HashSet<String> dummy = new HashSet<String>();
            this.registry.getIncludedFeatures(libs, deps, dummy);
            for (GadgetFeatureRegistry.Entry dep : deps) {
                libs.add(dep.getName());
            }
        }
        for (JsLibrary library : gadget.getJsLibraries()) {
            JsLibrary.Type type = library.getType();
            if (library.getType().equals((Object)JsLibrary.Type.URL)) {
                externJs.append(String.format(externFmt, library.getContent()));
                continue;
            }
            if (libs.contains(library.getFeature())) continue;
            if (this.context.getDebug()) {
                inlineJs.append(library.getDebugContent());
            } else {
                inlineJs.append(library.getContent());
            }
            inlineJs.append(";\n");
        }
        for (JsLibrary library : gadget.getJsLibraries()) {
            libs.add(library.getFeature());
        }
        this.appendJsConfig(gadget, libs, inlineJs);
        MessageBundle bundle = gadget.getMessageBundle();
        String msgs = new JSONObject(bundle.getMessages()).toString();
        inlineJs.append("gadgets.Prefs.setMessages_(").append(msgs).append(");");
        this.appendPreloads(gadget, inlineJs);
        if (inlineJs.length() > 0) {
            markup.append("<script><!--\n").append((CharSequence)inlineJs).append("\n-->\n</script>");
        }
        if (externJs.length() > 0) {
            markup.append((CharSequence)externJs);
        }
        LinkedList gadgetExceptions = new LinkedList();
        String content = view.getContent();
        for (GadgetContentFilter filter : this.filters) {
            content = filter.filter(content);
        }
        markup.append(content).append("<script>gadgets.util.runOnLoadHandlers();</script>").append("</body></html>");
        if (this.context.getIgnoreCache()) {
            HttpUtil.setCachingHeaders(this.response, 0);
        } else if (this.request.getParameter("v") != null) {
            HttpUtil.setCachingHeaders(this.response);
        } else {
            HttpUtil.setCachingHeaders(this.response, 300);
        }
        this.response.getWriter().print(markup.toString());
    }

    private void outputUrlGadget(Gadget gadget, View view) throws IOException {
        URI href = view.getHref();
        String queryStr = href.getQuery();
        StringBuilder query = new StringBuilder(queryStr == null ? "" : queryStr);
        Set<String> libs = gadget.getSpec().getModulePrefs().getFeatures().keySet();
        this.appendLibsToQuery(libs, query);
        try {
            href = new URI(href.getScheme(), href.getUserInfo(), href.getHost(), href.getPort(), href.getPath(), query.toString(), href.getFragment());
        }
        catch (URISyntaxException e) {
            this.response.sendError(500, e.getMessage());
        }
        this.response.sendRedirect(href.toString());
    }

    private void outputErrors(GadgetException error) throws IOException {
        logger.log(Level.INFO, "Failed to render gadget", error);
        String message = error.getMessage();
        if (message == null || message.length() == 0) {
            message = "Failed to render gadget: " + error.getCode().toString();
        }
        this.response.getWriter().print(message);
    }

    private void appendLibsToQuery(Set<String> libs, StringBuilder query) {
        query.append('&').append(LIBS_PARAM_NAME).append('=').append(this.urlGenerator.getBundledJsParam(libs, this.context));
    }

    protected boolean getUseCaja(HttpServletRequest req) {
        String cajaParam = this.request.getParameter(CAJA_PARAM);
        return "1".equals(cajaParam);
    }

    private void appendJsConfig(Gadget gadget, Set<String> reqs, StringBuilder js) {
        JSONObject json = HttpUtil.getJsConfig(this.containerConfig, this.context, reqs);
        ModulePrefs prefs = gadget.getSpec().getModulePrefs();
        JSONObject featureMap = new JSONObject();
        try {
            for (Feature feature : prefs.getFeatures().values()) {
                featureMap.put(feature.getName(), feature.getParams());
            }
            json.put("core.util", (Object)featureMap);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        js.append("gadgets.config.init(").append(json.toString()).append(");\n");
    }

    private void appendPreloads(Gadget gadget, StringBuilder inlineJs) {
        JSONObject resp = new JSONObject();
        for (Map.Entry<Preload, Future<RemoteContent>> entry : gadget.getPreloadMap().entrySet()) {
            Preload preload = entry.getKey();
            try {
                RemoteContent response = entry.getValue().get();
                JSONObject jsonEntry = new JSONObject();
                jsonEntry.put("body", (Object)response.getResponseAsString()).put("rc", response.getHttpStatusCode());
                resp.put(entry.getKey().getHref().toString(), (Object)jsonEntry);
            }
            catch (JSONException e) {
                logger.log(Level.INFO, "Error outputting preload for " + preload.getHref(), e);
            }
            catch (InterruptedException e) {
                logger.log(Level.INFO, "Error scheduling preload for " + preload.getHref(), e);
            }
            catch (ExecutionException e) {
                logger.log(Level.INFO, "Error executing preload for " + preload.getHref(), e.getCause());
            }
        }
        inlineJs.append("gadgets.io.preloaded_ = ").append(resp.toString()).append(";\n");
    }

    private boolean validateParent() {
        String parent;
        String container = this.request.getParameter("container");
        if (container == null && (container = this.request.getParameter("synd")) == null) {
            container = "default";
        }
        if ((parent = this.request.getParameter("parent")) == null) {
            return true;
        }
        try {
            JSONArray parents = this.containerConfig.getJsonArray(container, "gadgets.parent");
            if (parents == null) {
                return true;
            }
            int j = parents.length();
            for (int i = 0; i < j; ++i) {
                if (!Pattern.matches(parents.getString(i), parent)) continue;
                return true;
            }
        }
        catch (JSONException e) {
            logger.log(Level.WARNING, "Configuration error", e);
        }
        return false;
    }

    @Inject
    public GadgetRenderingTask(GadgetServer server, GadgetFeatureRegistry registry, ContainerConfig containerConfig, UrlGenerator urlGenerator, GadgetTokenDecoder tokenDecoder) {
        this.server = server;
        this.registry = registry;
        this.containerConfig = containerConfig;
        this.urlGenerator = urlGenerator;
        this.tokenDecoder = tokenDecoder;
        this.filters = new LinkedList<GadgetContentFilter>();
    }
}

