/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class GuiceServletContextListener
implements ServletContextListener {
    public static final String INJECTOR_ATTRIBUTE = "guice-injector";
    public static final String MODULES_ATTRIBUTE = "guice-modules";

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        String moduleNames = context.getInitParameter(MODULES_ATTRIBUTE);
        LinkedList<Module> modules = new LinkedList<Module>();
        if (moduleNames != null) {
            for (String moduleName : moduleNames.split(":")) {
                try {
                    modules.add((Module)Class.forName(moduleName).newInstance());
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        context.setAttribute(INJECTOR_ATTRIBUTE, (Object)Guice.createInjector(modules));
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        context.removeAttribute(INJECTOR_ATTRIBUTE);
    }
}

