/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.gadgets.GadgetTokenDecoder;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.UserPrefs;

public class HttpGadgetContext
extends GadgetContext {
    public static final String USERPREF_PARAM_PREFIX = "up_";
    private final URI url;
    private final Integer moduleId;
    private final Locale locale;
    private final RenderingContext renderingContext;
    private final Boolean ignoreCache;
    private final String container;
    private final Boolean debug;
    private final String view;
    private final UserPrefs userPrefs;
    private final String tokenString;
    private final GadgetTokenDecoder tokenDecoder;

    public URI getUrl() {
        if (this.url == null) {
            return super.getUrl();
        }
        return this.url;
    }

    public int getModuleId() {
        if (this.moduleId == null) {
            return super.getModuleId();
        }
        return this.moduleId;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return super.getLocale();
        }
        return this.locale;
    }

    private static URI getUrl(HttpServletRequest req) {
        String url = req.getParameter("url");
        if (url == null) {
            return null;
        }
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static Integer getModuleId(HttpServletRequest req) {
        String mid = req.getParameter("mid");
        if (mid == null) {
            return null;
        }
        return Integer.parseInt(mid);
    }

    private static Locale getLocale(HttpServletRequest req) {
        String language = req.getParameter("lang");
        String country = req.getParameter("country");
        if (language == null && country == null) {
            return null;
        }
        if (language == null) {
            language = "all";
        } else if (country == null) {
            country = "ALL";
        }
        return new Locale(language, country);
    }

    public RenderingContext getRenderingContext() {
        if (this.renderingContext == null) {
            return super.getRenderingContext();
        }
        return this.renderingContext;
    }

    private static RenderingContext getRenderingContext(HttpServletRequest req) {
        String c = req.getParameter("c");
        if (c == null) {
            return null;
        }
        return c.equals("1") ? RenderingContext.CONTAINER : RenderingContext.GADGET;
    }

    public boolean getIgnoreCache() {
        if (this.ignoreCache == null) {
            return super.getIgnoreCache();
        }
        return this.ignoreCache;
    }

    private static Boolean getIgnoreCache(HttpServletRequest req) {
        String ignoreCache = req.getParameter("nocache");
        if (ignoreCache == null) {
            return null;
        }
        if ("0".equals(ignoreCache)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getContainer() {
        if (this.container == null) {
            return super.getContainer();
        }
        return this.container;
    }

    private static String getContainer(HttpServletRequest req) {
        String container = req.getParameter("container");
        if (container == null) {
            container = req.getParameter("synd");
        }
        return container;
    }

    public boolean getDebug() {
        if (this.debug == null) {
            return super.getDebug();
        }
        return this.debug;
    }

    private static Boolean getDebug(HttpServletRequest req) {
        String debug = req.getParameter("debug");
        if (debug == null) {
            return null;
        }
        if ("0".equals(debug)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getView() {
        if (this.view == null) {
            return super.getView();
        }
        return this.view;
    }

    private static String getView(HttpServletRequest req) {
        return req.getParameter("view");
    }

    public UserPrefs getUserPrefs() {
        if (this.userPrefs == null) {
            return super.getUserPrefs();
        }
        return this.userPrefs;
    }

    private static UserPrefs getUserPrefs(HttpServletRequest req) {
        HashMap<String, String> prefs = new HashMap<String, String>();
        Enumeration paramNames = req.getParameterNames();
        if (paramNames == null) {
            return null;
        }
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!paramName.startsWith(USERPREF_PARAM_PREFIX)) continue;
            String prefName = paramName.substring(USERPREF_PARAM_PREFIX.length());
            String escapedParam = prefs.put(prefName, req.getParameter(paramName));
        }
        return new UserPrefs(prefs);
    }

    public GadgetToken getToken() throws GadgetException {
        if (this.tokenString == null || this.tokenString.length() == 0) {
            return super.getToken();
        }
        return this.tokenDecoder.createToken(this.tokenString);
    }

    public HttpGadgetContext(HttpServletRequest request, GadgetTokenDecoder tokenDecoder) {
        this.url = HttpGadgetContext.getUrl(request);
        this.moduleId = HttpGadgetContext.getModuleId(request);
        this.locale = HttpGadgetContext.getLocale(request);
        this.renderingContext = HttpGadgetContext.getRenderingContext(request);
        this.ignoreCache = HttpGadgetContext.getIgnoreCache(request);
        this.container = HttpGadgetContext.getContainer(request);
        this.debug = HttpGadgetContext.getDebug(request);
        this.view = HttpGadgetContext.getView(request);
        this.userPrefs = HttpGadgetContext.getUserPrefs(request);
        this.tokenString = request.getParameter("st");
        this.tokenDecoder = tokenDecoder;
    }
}

