/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.gadgets.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtil {
    public static final long START_TIME = System.currentTimeMillis();
    private static final int DEFAULT_TTL = 31536000;

    public static void setCachingHeaders(HttpServletResponse response) {
        HttpUtil.setCachingHeaders(response, 31536000);
    }

    public static void setCachingHeaders(HttpServletResponse response, int ttl) {
        response.setDateHeader("Expires", System.currentTimeMillis() + 1000L * (long)ttl);
        if (ttl == 0) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
        } else {
            response.setHeader("Cache-Control", "public,max-age=" + Integer.toString(ttl));
        }
        response.setDateHeader("Last-Modified", START_TIME);
    }

    public static JSONObject getJsConfig(ContainerConfig config, GadgetContext context, Set<String> features) {
        JSONObject containerFeatures = config.getJsonObject(context.getContainer(), "gadgets.features");
        if (containerFeatures != null) {
            String[] featArray = features.toArray(new String[features.size()]);
            try {
                return new JSONObject(containerFeatures, featArray);
            }
            catch (JSONException e) {
                return null;
            }
        }
        return new JSONObject();
    }

    public static View getView(Gadget gadget, ContainerConfig config) {
        GadgetContext context = gadget.getContext();
        String viewName = context.getView();
        GadgetSpec spec = gadget.getSpec();
        View view = spec.getView(viewName);
        if (view == null) {
            JSONArray aliases = config.getJsonArray(context.getContainer(), "gadgets.features/views/" + viewName + "/aliases");
            if (aliases != null) {
                try {
                    int j = aliases.length();
                    for (int i = 0; i < j && (view = spec.getView(viewName = aliases.getString(i))) == null; ++i) {
                    }
                }
                catch (JSONException e) {
                    view = null;
                }
            }
            if (view == null) {
                view = gadget.getSpec().getView("default");
            }
        }
        return view;
    }
}

