/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureFactory;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.GadgetTokenDecoder;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.http.HttpGadgetContext;
import org.apache.shindig.gadgets.http.HttpUtil;
import org.apache.shindig.gadgets.http.InjectedServlet;

public class JsServlet
extends InjectedServlet {
    private GadgetFeatureRegistry registry;
    private GadgetTokenDecoder tokenDecoder;

    @Inject
    public void setRegistry(GadgetFeatureRegistry registry) {
        this.registry = registry;
    }

    @Inject
    public void setRegistry(GadgetTokenDecoder tokenDecoder) {
        this.tokenDecoder = tokenDecoder;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getHeader("If-Modified-Since") != null && req.getParameter("v") != null) {
            resp.setStatus(304);
            return;
        }
        String uri = req.getRequestURI();
        String resourceName = uri.substring(uri.lastIndexOf(47) + 1);
        if (resourceName.endsWith(".js")) {
            resourceName = resourceName.substring(0, resourceName.length() - ".js".length());
        }
        HashSet<String> needed = new HashSet<String>();
        if (resourceName.contains(":")) {
            needed.addAll(Arrays.asList(resourceName.split(":")));
        } else {
            needed.add(resourceName);
        }
        HashSet<GadgetFeatureRegistry.Entry> found = new HashSet<GadgetFeatureRegistry.Entry>();
        HashSet<String> dummy = new HashSet<String>();
        this.registry.getIncludedFeatures(needed, found, dummy);
        StringBuilder jsData = new StringBuilder();
        HttpGadgetContext context = new HttpGadgetContext(req, this.tokenDecoder);
        HashSet<String> features = new HashSet<String>(found.size());
        do {
            for (GadgetFeatureRegistry.Entry entry : found) {
                if (features.contains(entry.getName()) || !features.containsAll(entry.getDependencies())) continue;
                features.add(entry.getName());
                GadgetFeatureFactory factory = entry.getFeature();
                GadgetFeature feature = factory.create();
                for (JsLibrary lib : feature.getJsLibraries(context)) {
                    if (lib.getType().equals((Object)JsLibrary.Type.URL)) continue;
                    if (((GadgetContext)context).getDebug()) {
                        jsData.append(lib.getDebugContent());
                    } else {
                        jsData.append(lib.getContent());
                    }
                    jsData.append(";\n");
                }
            }
        } while (features.size() != found.size());
        if (jsData.length() == 0) {
            resp.setStatus(404);
            return;
        }
        if (req.getParameter("v") != null) {
            HttpUtil.setCachingHeaders(resp);
        } else {
            HttpUtil.setCachingHeaders(resp, 3600);
        }
        resp.setContentType("text/javascript; charset=utf-8");
        resp.setContentLength(jsData.length());
        resp.getOutputStream().write(jsData.toString().getBytes());
    }
}

