/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetServer;
import org.apache.shindig.gadgets.http.JsonRpcGadgetContext;
import org.apache.shindig.gadgets.http.RpcException;
import org.apache.shindig.gadgets.http.UrlGenerator;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRpcHandler {
    private final Executor executor;
    private GadgetServer server;
    private UrlGenerator urlGenerator;

    public JSONObject process(JSONObject request) throws RpcException, JSONException {
        JSONObject response = new JSONObject();
        ExecutorCompletionService<JSONObject> processor = new ExecutorCompletionService<JSONObject>(this.executor);
        JSONObject requestContext = request.getJSONObject("context");
        JSONArray requestedGadgets = request.getJSONArray("gadgets");
        ArrayList<JsonRpcGadgetContext> gadgets = new ArrayList<JsonRpcGadgetContext>(requestedGadgets.length());
        int n = requestedGadgets.length();
        for (int i = 0; i < n; ++i) {
            JsonRpcGadgetContext context = new JsonRpcGadgetContext(requestContext, requestedGadgets.getJSONObject(i));
            gadgets.add(context);
        }
        for (GadgetContext gadgetContext : gadgets) {
            processor.submit(new Job(gadgetContext));
        }
        int numJobs = gadgets.size();
        do {
            try {
                JSONObject jSONObject = (JSONObject)processor.take().get();
                response.append("gadgets", (Object)jSONObject);
            }
            catch (InterruptedException interruptedException) {
                throw new RpcException("Processing interrupted", (Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                if (!(executionException.getCause() instanceof RpcException)) {
                    throw new RpcException("Processing interrupted", (Throwable)executionException);
                }
                RpcException e = (RpcException)executionException.getCause();
                try {
                    GadgetContext context = e.getContext();
                    if (context == null) {
                        throw e;
                    }
                    JSONObject errorObj = new JSONObject();
                    errorObj.put("url", (Object)context.getUrl()).put("moduleId", context.getModuleId());
                    if (e.getCause() instanceof GadgetException) {
                        GadgetException gpe = (GadgetException)e.getCause();
                        errorObj.append("errors", (Object)gpe.getMessage());
                    } else {
                        errorObj.append("errors", (Object)e.getMessage());
                    }
                    response.append("gadgets", (Object)errorObj);
                }
                catch (JSONException je) {
                    throw new RpcException("Unable to write JSON", (Throwable)je);
                }
            }
            catch (JSONException jSONException) {
                throw new RpcException("Unable to write JSON", (Throwable)jSONException);
            }
            finally {
                --numJobs;
            }
        } while (numJobs > 0);
        return response;
    }

    @Inject
    public JsonRpcHandler(Executor executor, GadgetServer server, UrlGenerator iframeUrlGenerator) {
        this.executor = executor;
        this.server = server;
        this.urlGenerator = iframeUrlGenerator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Job
    implements Callable<JSONObject> {
        private final GadgetContext context;

        @Override
        public JSONObject call() throws RpcException {
            try {
                Gadget gadget = JsonRpcHandler.this.server.processGadget(this.context);
                JSONObject gadgetJson = new JSONObject();
                GadgetSpec spec = gadget.getSpec();
                ModulePrefs prefs = spec.getModulePrefs();
                JSONObject views = new JSONObject();
                for (View view : spec.getViews().values()) {
                    views.put(view.getName(), (Object)new JSONObject().put("type", (Object)view.getType().toString().toLowerCase()).put("quirks", view.getQuirks()));
                }
                Set<String> feats = prefs.getFeatures().keySet();
                String[] features = feats.toArray(new String[feats.size()]);
                JSONObject userPrefs = new JSONObject();
                for (UserPref pref : spec.getUserPrefs()) {
                    JSONObject up = new JSONObject().put("displayName", (Object)pref.getDisplayName()).put("type", (Object)pref.getDataType().toString().toLowerCase()).put("default", (Object)pref.getDefaultValue()).put("enumValues", pref.getEnumValues());
                    userPrefs.put(pref.getName(), (Object)up);
                }
                gadgetJson.put("iframeUrl", (Object)JsonRpcHandler.this.urlGenerator.getIframeUrl(gadget)).put("url", (Object)gadget.getContext().getUrl().toString()).put("moduleId", gadget.getContext().getModuleId()).put("title", (Object)prefs.getTitle()).put("titleUrl", (Object)prefs.getTitleUrl().toString()).put("views", (Object)views).put("features", (Object)features).put("userPrefs", (Object)userPrefs).put("directoryTitle", (Object)prefs.getDirectoryTitle()).put("thumbnail", (Object)prefs.getThumbnail().toString()).put("screenshot", (Object)prefs.getScreenshot().toString()).put("author", (Object)prefs.getAuthor()).put("authorEmail", (Object)prefs.getAuthorEmail()).put("authorAffiliation", (Object)prefs.getAuthorAffiliation()).put("authorLocation", (Object)prefs.getAuthorLocation()).put("authorPhoto", (Object)prefs.getAuthorPhoto()).put("authorAboutme", (Object)prefs.getAuthorAboutme()).put("authorQuote", (Object)prefs.getAuthorQuote()).put("authorLink", (Object)prefs.getAuthorLink()).put("categories", prefs.getCategories()).put("screenshot", (Object)prefs.getScreenshot().toString()).put("height", prefs.getHeight()).put("width", prefs.getWidth()).put("showStats", prefs.getShowStats()).put("showInDirectory", prefs.getShowInDirectory()).put("singleton", prefs.getSingleton()).put("scaling", prefs.getScaling()).put("scrolling", prefs.getScrolling());
                return gadgetJson;
            }
            catch (GadgetException e) {
                throw new RpcException(this.context, (Throwable)e);
            }
            catch (JSONException e) {
                throw new RpcException(this.context, (Throwable)e);
            }
        }

        public Job(GadgetContext context) {
            this.context = context;
        }
    }
}

