/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.ContentFetcherFactory;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.gadgets.GadgetTokenDecoder;
import org.apache.shindig.gadgets.RemoteContent;
import org.apache.shindig.gadgets.RemoteContentRequest;
import org.apache.shindig.gadgets.http.HttpUtil;
import org.apache.shindig.gadgets.oauth.OAuthRequestParams;
import org.apache.shindig.gadgets.spec.Auth;
import org.apache.shindig.util.InputStreamConsumer;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHandler {
    public static final String UNPARSEABLE_CRUFT = "throw 1; < don't be evil' >";
    public static final String POST_DATA_PARAM = "postData";
    public static final String METHOD_PARAM = "httpMethod";
    public static final String SECURITY_TOKEN_PARAM = "st";
    public static final String HEADERS_PARAM = "headers";
    public static final String NOCACHE_PARAM = "nocache";
    public static final String URL_PARAM = "url";
    private static final String REFRESH_PARAM = "refresh";
    private final GadgetTokenDecoder gadgetTokenDecoder;
    private static final Set<String> DISALLOWED_RESPONSE_HEADERS = new HashSet<String>();
    private ContentFetcherFactory contentFetcherFactory;

    @Inject
    public void setContentFetcher(ContentFetcherFactory contentFetcherFactory) {
        this.contentFetcherFactory = contentFetcherFactory;
    }

    @Inject
    public ProxyHandler(ContentFetcherFactory contentFetcherFactory, GadgetTokenDecoder gadgetTokenDecoder) {
        this.contentFetcherFactory = contentFetcherFactory;
        this.gadgetTokenDecoder = gadgetTokenDecoder;
    }

    public void fetchJson(HttpServletRequest request, HttpServletResponse response) throws IOException, GadgetException {
        RemoteContentRequest rcr = this.buildRemoteContentRequest(request);
        ContentFetcher fetcher = this.getContentFetcher(request, response);
        RemoteContent results = fetcher.fetch(rcr);
        String output = this.serializeJsonResponse(request, results);
        int refreshInterval = 0;
        if (request.getParameter(REFRESH_PARAM) != null) {
            refreshInterval = Integer.valueOf(request.getParameter(REFRESH_PARAM));
        }
        HttpUtil.setCachingHeaders(response, refreshInterval);
        response.setStatus(200);
        response.setContentType("application/json; charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=p.txt");
        response.getWriter().write(output);
    }

    private RemoteContentRequest buildRemoteContentRequest(HttpServletRequest request) throws GadgetException {
        try {
            String encoding = request.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            URI url = this.validateUrl(request.getParameter(URL_PARAM));
            String method = request.getMethod();
            Map<String, List<String>> headers = null;
            byte[] postBody = null;
            if ("POST".equals(method)) {
                method = ProxyHandler.getParameter(request, METHOD_PARAM, "GET");
                postBody = ProxyHandler.getParameter(request, POST_DATA_PARAM, "").getBytes();
                String headerData = request.getParameter(HEADERS_PARAM);
                if (headerData == null || headerData.length() == 0) {
                    headers = Collections.emptyMap();
                } else {
                    String[] headerList;
                    headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                    for (String header : headerList = headerData.split("&")) {
                        String[] parts = header.split("=");
                        if (parts.length != 2) {
                            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "malformed header specified");
                        }
                        headers.put(URLDecoder.decode(parts[0], encoding), Arrays.asList(URLDecoder.decode(parts[1], encoding)));
                    }
                }
            } else {
                postBody = null;
                headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String header = (String)headerNames.nextElement();
                    headers.put(header, Collections.list(request.getHeaders(header)));
                }
            }
            this.removeUnsafeHeaders(headers);
            RemoteContentRequest.Options options = new RemoteContentRequest.Options();
            options.ignoreCache = "1".equals(request.getParameter(NOCACHE_PARAM));
            return new RemoteContentRequest(method, url, headers, postBody, options);
        }
        catch (UnsupportedEncodingException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private ContentFetcher getContentFetcher(HttpServletRequest request, HttpServletResponse response) throws GadgetException {
        String authzType = ProxyHandler.getParameter(request, "authz", "");
        Auth auth = Auth.parse(authzType);
        switch (auth) {
            case NONE: {
                return this.contentFetcherFactory.get();
            }
            case SIGNED: {
                return this.contentFetcherFactory.getSigningFetcher(this.extractAndValidateToken(request));
            }
            case AUTHENTICATED: {
                return this.contentFetcherFactory.getOAuthFetcher(this.extractAndValidateToken(request), new OAuthRequestParams(request));
            }
        }
        return this.contentFetcherFactory.get();
    }

    private String serializeJsonResponse(HttpServletRequest request, RemoteContent results) {
        try {
            JSONObject resp = new JSONObject();
            if (results != null) {
                resp.put("body", (Object)results.getResponseAsString());
                resp.put("rc", results.getHttpStatusCode());
            }
            for (Map.Entry<String, String> entry : results.getMetadata().entrySet()) {
                resp.put(entry.getKey(), (Object)entry.getValue());
            }
            String originalUrl = request.getParameter(URL_PARAM);
            JSONObject json = new JSONObject().put(originalUrl, (Object)resp);
            return UNPARSEABLE_CRUFT + json.toString();
        }
        catch (JSONException e) {
            return "";
        }
    }

    public void fetch(HttpServletRequest request, HttpServletResponse response) throws IOException, GadgetException {
        if (request.getHeader("If-Modified-Since") != null) {
            response.setStatus(304);
            return;
        }
        RemoteContentRequest rcr = this.buildRemoteContentRequest(request);
        RemoteContent results = this.contentFetcherFactory.get().fetch(rcr);
        int status = results.getHttpStatusCode();
        response.setStatus(status);
        if (status == 200) {
            Map<String, List<String>> headers = results.getAllHeaders();
            if (headers.get("Cache-Control") == null) {
                HttpUtil.setCachingHeaders(response, 3600);
            }
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String name = entry.getKey();
                List<String> values = entry.getValue();
                if (name == null || values == null || DISALLOWED_RESPONSE_HEADERS.contains(name.toLowerCase())) continue;
                for (String value : values) {
                    response.addHeader(name, value);
                }
            }
            response.getOutputStream().write(InputStreamConsumer.readToByteArray(results.getResponse()));
        }
    }

    private void removeUnsafeHeaders(Map<String, List<String>> headers) {
        String[] badHeaders;
        for (String bad : badHeaders = new String[]{"Host", "Accept", "Accept-Encoding"}) {
            headers.remove(bad);
        }
    }

    public URI validateUrl(String urlToValidate) throws GadgetException {
        if (urlToValidate == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "url parameter is missing.");
        }
        try {
            URI url = new URI(urlToValidate);
            if (!"http".equals(url.getScheme()) && !"https".equals(url.getScheme())) {
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Invalid request url scheme; only \"http\" and \"https\" supported.");
            }
            if (url.getPath() == null || url.getPath().length() == 0) {
                url = new URI(url.getScheme(), url.getUserInfo(), url.getHost(), url.getPort(), "/", url.getQuery(), url.getFragment());
            }
            return url;
        }
        catch (URISyntaxException use) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "url parameter is not a valid url.");
        }
    }

    private GadgetToken extractAndValidateToken(HttpServletRequest request) throws GadgetException {
        String token = ProxyHandler.getParameter(request, SECURITY_TOKEN_PARAM, "");
        return this.gadgetTokenDecoder.createToken(token);
    }

    private static String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String ret = request.getParameter(name);
        return ret == null ? defaultValue : ret;
    }

    static {
        DISALLOWED_RESPONSE_HEADERS.add("set-cookie");
        DISALLOWED_RESPONSE_HEADERS.add("content-length");
        DISALLOWED_RESPONSE_HEADERS.add("content-encoding");
        DISALLOWED_RESPONSE_HEADERS.add("etag");
        DISALLOWED_RESPONSE_HEADERS.add("last-modified");
        DISALLOWED_RESPONSE_HEADERS.add("accept-ranges");
        DISALLOWED_RESPONSE_HEADERS.add("vary");
    }
}

