/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.InjectedServlet;
import org.apache.shindig.gadgets.http.ProxyHandler;

public class ProxyServlet
extends InjectedServlet {
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");
    private ProxyHandler proxyHandler;

    @Inject
    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String output = request.getParameter("output");
        try {
            if ("js".equals(output)) {
                this.proxyHandler.fetchJson(request, response);
            } else {
                this.proxyHandler.fetch(request, response);
            }
        }
        catch (GadgetException ge) {
            this.outputError(ge, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void outputError(GadgetException excep, HttpServletResponse resp) throws IOException {
        StringBuilder err = new StringBuilder();
        err.append(excep.getCode().toString());
        err.append(' ');
        err.append(excep.getMessage());
        logger.log(Level.INFO, "Proxy request failed", err);
        resp.sendError(400, err.toString());
    }
}

