/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.shindig.gadgets.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureFactory;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.http.HttpUtil;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.util.HashUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlGenerator {
    private final String jsPrefix;
    private final String iframePrefix;
    private final String jsChecksum;
    private final ContainerConfig containerConfig;
    private static final Pattern ALLOWED_FEATURE_NAME = Pattern.compile("[0-9a-zA-Z\\.\\-]+");

    public String getBundledJsUrl(Collection<String> features, GadgetContext context) {
        return this.jsPrefix + this.getBundledJsParam(features, context);
    }

    public String getBundledJsParam(Collection<String> features, GadgetContext context) {
        StringBuilder buf = new StringBuilder();
        boolean first = false;
        for (String feature : features) {
            if (!ALLOWED_FEATURE_NAME.matcher(feature).matches()) continue;
            if (!first) {
                first = true;
            } else {
                buf.append(':');
            }
            buf.append(feature);
        }
        buf.append(".js?v=").append(this.jsChecksum).append("&container=").append(context.getContainer()).append("&debug=").append(context.getDebug() ? "1" : "0");
        return buf.toString();
    }

    public String getIframeUrl(Gadget gadget) {
        StringBuilder buf = new StringBuilder();
        GadgetContext context = gadget.getContext();
        GadgetSpec spec = gadget.getSpec();
        try {
            String url = context.getUrl().toString();
            View view = HttpUtil.getView(gadget, this.containerConfig);
            View.ContentType type = view == null ? View.ContentType.HTML : view.getType();
            switch (type) {
                case URL: {
                    buf.append(view.getHref());
                    if (url.indexOf(63) == -1) {
                        buf.append('?');
                        break;
                    }
                    buf.append('&');
                    break;
                }
                default: {
                    buf.append(this.iframePrefix).append("url=").append(URLEncoder.encode(url, "UTF-8")).append("&");
                }
            }
            buf.append("container=").append(context.getContainer());
            if (context.getModuleId() != 0) {
                buf.append("&mid=").append(context.getModuleId());
            }
            if (context.getIgnoreCache()) {
                buf.append("&nocache=1");
            } else {
                buf.append("&v=").append(spec.getChecksum());
            }
            buf.append("&lang=").append(context.getLocale().getLanguage());
            buf.append("&country=").append(context.getLocale().getCountry());
            UserPrefs prefs = context.getUserPrefs();
            for (UserPref pref : gadget.getSpec().getUserPrefs()) {
                String name = pref.getName();
                String value = prefs.getPref(name);
                if (value == null) {
                    value = pref.getDefaultValue();
                }
                buf.append("&up_").append(URLEncoder.encode(pref.getName(), "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 Not supported!", e);
        }
        return buf.toString();
    }

    @Inject
    public UrlGenerator(@Named(value="urls.iframe.prefix") String iframePrefix, @Named(value="urls.js.prefix") String jsPrefix, GadgetFeatureRegistry registry, ContainerConfig containerConfig) {
        this.iframePrefix = iframePrefix;
        this.jsPrefix = jsPrefix;
        this.containerConfig = containerConfig;
        StringBuilder jsBuf = new StringBuilder();
        for (Map.Entry<String, GadgetFeatureRegistry.Entry> entry : registry.getAllFeatures().entrySet()) {
            GadgetFeatureFactory factory = entry.getValue().getFeature();
            GadgetFeature feature = factory.create();
            for (JsLibrary library : feature.getJsLibraries(null)) {
                jsBuf.append(library.getContent());
            }
        }
        this.jsChecksum = HashUtil.checksum(jsBuf.toString().getBytes());
    }
}

