/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.RemoteContent;
import org.apache.shindig.gadgets.RemoteContentRequest;
import org.apache.shindig.gadgets.oauth.GadgetOAuthTokenStore;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.apache.shindig.gadgets.oauth.OAuthStoreException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.util.ResourceLoader;
import org.json.JSONException;
import org.json.JSONObject;

public class BasicGadgetOAuthTokenStore
extends GadgetOAuthTokenStore {
    private static final String OAUTH_CONFIG = "config/oauth.json";
    private static final String CONSUMER_SECRET_KEY = "consumer_secret";
    private static final String CONSUMER_KEY_KEY = "consumer_key";
    private static final String KEY_TYPE_KEY = "key_type";

    public BasicGadgetOAuthTokenStore(OAuthStore store) {
        super(store);
    }

    public void initFromConfigFile(ContentFetcher fetcher) throws GadgetException {
        try {
            String oauthConfigStr = ResourceLoader.getContent(OAUTH_CONFIG);
            JSONObject oauthConfigs = new JSONObject(oauthConfigStr);
            Iterator i = oauthConfigs.keys();
            while (i.hasNext()) {
                String url = (String)i.next();
                URI gadgetUri = new URI(url);
                this.storeProviderInfos(fetcher, gadgetUri);
                JSONObject oauthConfig = oauthConfigs.getJSONObject(url);
                this.storeConsumerInfos(gadgetUri, oauthConfig);
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, (Throwable)e);
        }
        catch (JSONException e) {
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, (Throwable)e);
        }
    }

    private void storeProviderInfos(ContentFetcher fetcher, URI gadgetUri) throws GadgetException {
        RemoteContentRequest request = RemoteContentRequest.getRequest(gadgetUri, false);
        RemoteContent response = fetcher.fetch(request);
        GadgetSpec spec = new GadgetSpec(gadgetUri, response.getResponseAsString());
        this.storeServiceInfoFromGadgetSpec(gadgetUri, spec);
    }

    private void storeConsumerInfos(URI gadgetUri, JSONObject oauthConfig) throws JSONException, OAuthStoreException {
        for (String serviceName : JSONObject.getNames((JSONObject)oauthConfig)) {
            JSONObject consumerInfo = oauthConfig.getJSONObject(serviceName);
            this.storeConsumerInfo(gadgetUri, serviceName, consumerInfo);
        }
    }

    private void storeConsumerInfo(URI gadgetUri, String serviceName, JSONObject consumerInfo) throws JSONException, OAuthStoreException {
        String consumerSecret = consumerInfo.getString(CONSUMER_SECRET_KEY);
        String consumerKey = consumerInfo.getString(CONSUMER_KEY_KEY);
        String keyTypeStr = consumerInfo.getString(KEY_TYPE_KEY);
        OAuthStore.KeyType keyType = OAuthStore.KeyType.HMAC_SYMMETRIC;
        if (keyTypeStr.equals("RSA_PRIVATE")) {
            keyType = OAuthStore.KeyType.RSA_PRIVATE;
        }
        OAuthStore.ConsumerKeyAndSecret kas = new OAuthStore.ConsumerKeyAndSecret(consumerKey, consumerSecret, keyType);
        this.storeConsumerKeyAndSecret(gadgetUri, serviceName, kas);
    }
}

