/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import java.util.HashMap;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.gadgets.oauth.OAuthNoDataException;
import org.apache.shindig.gadgets.oauth.OAuthStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicOAuthStore
implements OAuthStore {
    private Map<OAuthStore.ProviderKey, OAuthStore.ProviderInfo> providers = new HashMap<OAuthStore.ProviderKey, OAuthStore.ProviderInfo>();
    private Map<OAuthStore.TokenKey, OAuthStore.TokenInfo> tokens = new HashMap<OAuthStore.TokenKey, OAuthStore.TokenInfo>();
    private String defaultConsumerKey;
    private String defaultConsumerSecret;

    public BasicOAuthStore() {
        this(null, null);
    }

    public BasicOAuthStore(String consumerKey, String privateKey) {
        this.defaultConsumerKey = consumerKey;
        this.defaultConsumerSecret = privateKey;
    }

    void setHashMapsForTesting(Map<OAuthStore.ProviderKey, OAuthStore.ProviderInfo> providers, Map<OAuthStore.TokenKey, OAuthStore.TokenInfo> tokens) {
        this.providers = providers;
        this.tokens = tokens;
    }

    @Override
    public OAuthStore.AccessorInfo getOAuthAccessor(OAuthStore.TokenKey tokenKey) throws OAuthNoDataException {
        OAuthStore.ProviderKey provKey = new OAuthStore.ProviderKey();
        provKey.setGadgetUri(tokenKey.getGadgetUri());
        provKey.setServiceName(tokenKey.getServiceName());
        OAuthStore.AccessorInfo result = this.getOAuthAccessor(provKey);
        OAuthStore.TokenInfo accessToken = this.tokens.get(tokenKey);
        if (accessToken != null) {
            result.getAccessor().accessToken = accessToken.getAccessToken();
            result.getAccessor().tokenSecret = accessToken.getTokenSecret();
        }
        return result;
    }

    private OAuthStore.AccessorInfo getOAuthAccessor(OAuthStore.ProviderKey providerKey) throws OAuthNoDataException {
        OAuthConsumer consumer;
        OAuthServiceProvider oauthProvider;
        OAuthStore.ProviderInfo provInfo = this.providers.get(providerKey);
        if (provInfo == null) {
            throw new OAuthNoDataException("provider info was null in oauth store");
        }
        OAuthStore.AccessorInfo result = new OAuthStore.AccessorInfo();
        result.setHttpMethod(provInfo.getHttpMethod());
        result.setParamLocation(provInfo.getParamLocation());
        OAuthStore.ConsumerKeyAndSecret consumerKeyAndSecret = provInfo.getKeyAndSecret();
        if (consumerKeyAndSecret == null) {
            if (this.defaultConsumerKey == null || this.defaultConsumerSecret == null) {
                throw new OAuthNoDataException("ConsumerKeyAndSecret was null in oauth store");
            }
            consumerKeyAndSecret = new OAuthStore.ConsumerKeyAndSecret(this.defaultConsumerKey, this.defaultConsumerSecret, OAuthStore.KeyType.RSA_PRIVATE);
        }
        if ((oauthProvider = provInfo.getProvider()) == null) {
            throw new OAuthNoDataException("OAuthService provider was null in oauth store");
        }
        boolean usePublicKeyCrypto = consumerKeyAndSecret.getKeyType() == OAuthStore.KeyType.RSA_PRIVATE;
        OAuthConsumer oAuthConsumer = consumer = usePublicKeyCrypto ? new OAuthConsumer(null, consumerKeyAndSecret.getConsumerKey(), null, oauthProvider) : new OAuthConsumer(null, consumerKeyAndSecret.getConsumerKey(), consumerKeyAndSecret.getConsumerSecret(), oauthProvider);
        if (usePublicKeyCrypto) {
            consumer.setProperty("RSA-SHA1.PrivateKey", (Object)consumerKeyAndSecret.getConsumerSecret());
            result.setSignatureType(OAuthStore.SignatureType.RSA_SHA1);
        } else {
            result.setSignatureType(OAuthStore.SignatureType.HMAC_SHA1);
        }
        result.setAccessor(new OAuthAccessor(consumer));
        return result;
    }

    @Override
    public OAuthStore.ProviderInfo getOAuthServiceProviderInfo(OAuthStore.ProviderKey providerKey) throws OAuthNoDataException {
        OAuthStore.ProviderInfo provInfo = this.providers.get(providerKey);
        if (provInfo == null) {
            throw new OAuthNoDataException("provider info was null in oauth store");
        }
        return provInfo;
    }

    @Override
    public void setOAuthConsumerKeyAndSecret(OAuthStore.ProviderKey providerKey, OAuthStore.ConsumerKeyAndSecret keyAndSecret) throws OAuthNoDataException {
        OAuthStore.ProviderInfo provData = this.providers.get(providerKey);
        if (provData == null) {
            throw new OAuthNoDataException("could not find provider data for token");
        }
        provData.setKeyAndSecret(keyAndSecret);
    }

    @Override
    public void setOAuthServiceProviderInfo(OAuthStore.ProviderKey providerKey, OAuthStore.ProviderInfo providerInfo) {
        this.providers.put(providerKey, providerInfo);
    }

    @Override
    public void setTokenAndSecret(OAuthStore.TokenKey tokenKey, OAuthStore.TokenInfo tokenInfo) {
        this.tokens.put(tokenKey, tokenInfo);
    }
}

