/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import java.net.URI;
import java.util.Map;
import java.util.logging.Logger;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.OAuthNoDataException;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.apache.shindig.gadgets.oauth.OAuthStoreException;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetOAuthTokenStore {
    public static final String OAUTH_FEATURE = "oauth";
    public static final String SERVICE_NAME = "service_name";
    public static final String ACCESS_URL = "access_url";
    public static final String ACCESS_HTTP_METHOD = "access_method";
    public static final String REQUEST_URL = "request_url";
    public static final String REQUEST_HTTP_METHOD = "request_method";
    public static final String AUTHORIZE_URL = "authorize_url";
    public static final String OAUTH_PARAM_LOCATION = "param_location";
    public static final String AUTH_HEADER = "auth_header";
    public static final String POST_BODY = "post_body";
    public static final String URI_QUERY = "uri_query";
    public static final String DEFAULT_OAUTH_PARAM_LOCATION = "auth_header";
    private static final String DEFAULT_HTTP_METHOD = "POST";
    private static final Logger log = Logger.getLogger(GadgetOAuthTokenStore.class.getName());
    private OAuthStore store;

    public GadgetOAuthTokenStore(OAuthStore store) {
        this.store = store;
    }

    public void storeServiceInfoFromGadgetSpec(URI gadgetUrl, GadgetSpec spec) throws GadgetException {
        GadgetInfo gadgetInfo = GadgetOAuthTokenStore.getGadgetOAuthInfo(spec);
        OAuthStore.ProviderKey providerKey = new OAuthStore.ProviderKey();
        providerKey.setGadgetUri(gadgetUrl.toString());
        providerKey.setServiceName(gadgetInfo.getServiceName());
        this.store.setOAuthServiceProviderInfo(providerKey, gadgetInfo.getProviderInfo());
    }

    public void storeConsumerKeyAndSecret(URI gadgetUrl, String serviceName, OAuthStore.ConsumerKeyAndSecret keyAndSecret) throws OAuthStoreException, OAuthNoDataException {
        OAuthStore.ProviderKey providerKey = new OAuthStore.ProviderKey();
        providerKey.setGadgetUri(gadgetUrl.toString());
        providerKey.setServiceName(serviceName);
        this.store.setOAuthConsumerKeyAndSecret(providerKey, keyAndSecret);
    }

    public void storeTokenKeyAndSecret(OAuthStore.TokenKey tokenKey, OAuthStore.TokenInfo tokenInfo) throws OAuthStoreException {
        if (GadgetOAuthTokenStore.isEmpty(tokenKey.getGadgetUri())) {
            throw new IllegalArgumentException("found empty gadget URI in TokenKey");
        }
        if (GadgetOAuthTokenStore.isEmpty(tokenKey.getServiceName())) {
            throw new IllegalArgumentException("found empty service name in TokenKey");
        }
        if (GadgetOAuthTokenStore.isEmpty(tokenKey.getUserId())) {
            throw new IllegalArgumentException("found empty userId in TokenKey");
        }
        this.store.setTokenAndSecret(tokenKey, tokenInfo);
    }

    public OAuthStore.AccessorInfo getOAuthAccessor(OAuthStore.TokenKey tokenKey) throws OAuthNoDataException, OAuthStoreException {
        if (GadgetOAuthTokenStore.isEmpty(tokenKey.getGadgetUri())) {
            throw new IllegalArgumentException("found empty gadget URI in TokenKey");
        }
        if (GadgetOAuthTokenStore.isEmpty(tokenKey.getServiceName())) {
            throw new IllegalArgumentException("found empty service name in TokenKey");
        }
        if (GadgetOAuthTokenStore.isEmpty(tokenKey.getUserId())) {
            throw new IllegalArgumentException("found empty userId in TokenKey");
        }
        return this.store.getOAuthAccessor(tokenKey);
    }

    static GadgetInfo getGadgetOAuthInfo(GadgetSpec spec) throws GadgetException {
        OAuthStore.OAuthParamLocation paramLocation;
        OAuthStore.HttpMethod httpMethod;
        Feature oauthFeature = spec.getModulePrefs().getFeatures().get(OAUTH_FEATURE);
        if (oauthFeature == null) {
            String message = "gadget spec is missing oauth feature section";
            log.warning(message);
            throw new GadgetException(GadgetException.Code.MISSING_PARAMETER, message);
        }
        Map<String, String> oauthParams = oauthFeature.getParams();
        String serviceName = GadgetOAuthTokenStore.getOAuthParameter(oauthParams, SERVICE_NAME, false);
        String requestUrl = GadgetOAuthTokenStore.getOAuthParameter(oauthParams, REQUEST_URL, false);
        String requestMethod = GadgetOAuthTokenStore.getOAuthParameter(oauthParams, REQUEST_HTTP_METHOD, true);
        if (requestMethod == null) {
            requestMethod = DEFAULT_HTTP_METHOD;
        }
        String accessUrl = GadgetOAuthTokenStore.getOAuthParameter(oauthParams, ACCESS_URL, false);
        String accessMethod = GadgetOAuthTokenStore.getOAuthParameter(oauthParams, ACCESS_HTTP_METHOD, true);
        if (accessMethod == null) {
            accessMethod = DEFAULT_HTTP_METHOD;
        }
        if (!accessMethod.equalsIgnoreCase(requestMethod)) {
            String message = "HTTP methods of access and request URLs have to match. " + "access method was: " + accessMethod + ". request method was: " + requestMethod;
            log.warning(message);
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, message);
        }
        String authorizeUrl = GadgetOAuthTokenStore.getOAuthParameter(oauthParams, AUTHORIZE_URL, false);
        OAuthServiceProvider provider = new OAuthServiceProvider(requestUrl, authorizeUrl, accessUrl);
        if (accessMethod.equalsIgnoreCase("GET")) {
            httpMethod = OAuthStore.HttpMethod.GET;
        } else if (accessMethod.equalsIgnoreCase(DEFAULT_HTTP_METHOD)) {
            httpMethod = OAuthStore.HttpMethod.POST;
        } else {
            String message = "unknown http method in gadget spec: " + accessMethod;
            log.warning(message);
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, message);
        }
        String paramLocationStr = GadgetOAuthTokenStore.getOAuthParameter(oauthParams, OAUTH_PARAM_LOCATION, true);
        if (paramLocationStr == null) {
            paramLocationStr = "auth_header";
        }
        if (paramLocationStr.equalsIgnoreCase(POST_BODY)) {
            paramLocation = OAuthStore.OAuthParamLocation.POST_BODY;
        } else if (paramLocationStr.equalsIgnoreCase("auth_header")) {
            paramLocation = OAuthStore.OAuthParamLocation.AUTH_HEADER;
        } else if (paramLocationStr.equalsIgnoreCase(URI_QUERY)) {
            paramLocation = OAuthStore.OAuthParamLocation.URI_QUERY;
        } else {
            String message = "unknown OAuth param location in gadget spec: " + paramLocationStr;
            log.warning(message);
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, message);
        }
        if (httpMethod == OAuthStore.HttpMethod.GET && paramLocation == OAuthStore.OAuthParamLocation.POST_BODY) {
            String message = "found incompatible param_location requirement of " + "POST_BODY and http method GET.";
            log.warning(message);
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, message);
        }
        OAuthStore.ProviderInfo provInfo = new OAuthStore.ProviderInfo();
        provInfo.setHttpMethod(httpMethod);
        provInfo.setParamLocation(paramLocation);
        provInfo.setSignatureType(OAuthStore.SignatureType.HMAC_SHA1);
        provInfo.setProvider(provider);
        GadgetInfo gadgetInfo = new GadgetInfo();
        gadgetInfo.setProviderInfo(provInfo);
        gadgetInfo.setServiceName(serviceName);
        return gadgetInfo;
    }

    static String getOAuthParameter(Map<String, String> params, String paramName, boolean isOptional) throws GadgetException {
        String param = params.get(paramName);
        if (param == null && !isOptional) {
            String message = "parameter '" + paramName + "' missing in oauth feature section of gadget spec";
            log.warning(message);
            throw new GadgetException(GadgetException.Code.MISSING_PARAMETER, message);
        }
        return param == null ? null : param.trim();
    }

    static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    static class GadgetInfo {
        private String serviceName;
        private OAuthStore.ProviderInfo providerInfo;

        GadgetInfo() {
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public OAuthStore.ProviderInfo getProviderInfo() {
            return this.providerInfo;
        }

        public void setProviderInfo(OAuthStore.ProviderInfo providerInfo) {
            this.providerInfo = providerInfo;
        }
    }
}

