/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import org.apache.shindig.gadgets.ChainedContentFetcher;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.gadgets.RemoteContent;
import org.apache.shindig.gadgets.RemoteContentRequest;
import org.apache.shindig.gadgets.oauth.GadgetOAuthTokenStore;
import org.apache.shindig.gadgets.oauth.OAuthRequestParams;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.apache.shindig.util.BlobCrypter;
import org.apache.shindig.util.BlobCrypterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthFetcher
extends ChainedContentFetcher {
    private static final String REQ_TOKEN_KEY = "r";
    private static final String REQ_TOKEN_SECRET_KEY = "rs";
    private static final String ACCESS_TOKEN_KEY = "a";
    private static final String ACCESS_TOKEN_SECRET_KEY = "as";
    private static final String OWNER_KEY = "o";
    public static final String CLIENT_STATE = "oauthState";
    public static final String APPROVAL_URL = "approvalUrl";
    private static final int CLIENT_STATE_MAX_AGE_SECS = 3600;
    protected final GadgetToken authToken;
    protected final String serviceName;
    protected final String tokenName;
    protected GadgetOAuthTokenStore tokenStore;
    private OAuthStore.AccessorInfo accessorInfo;
    private BlobCrypter oauthCrypter;
    private Map<String, String> origClientState;
    private RemoteContentRequest realRequest;
    private String newClientState;
    private String aznUrl;

    public OAuthFetcher(GadgetOAuthTokenStore tokenStore, BlobCrypter oauthCrypter, ContentFetcher nextFetcher, GadgetToken authToken, OAuthRequestParams params) {
        super(nextFetcher);
        this.oauthCrypter = oauthCrypter;
        this.authToken = authToken;
        this.serviceName = params.getServiceName();
        this.tokenName = params.getTokenName();
        this.newClientState = null;
        this.aznUrl = null;
        String origClientState = params.getOrigClientState();
        if (origClientState != null && origClientState.length() > 0) {
            try {
                this.origClientState = oauthCrypter.unwrap(origClientState, 3600);
            }
            catch (BlobCrypterException e) {
                // empty catch block
            }
        }
        if (this.origClientState == null) {
            this.origClientState = new HashMap<String, String>();
        }
        this.tokenStore = tokenStore;
    }

    public void init() throws GadgetException {
        this.lookupOAuthMetadata();
    }

    protected void lookupOAuthMetadata() throws GadgetException {
        OAuthStore.TokenKey tokenKey = this.buildTokenKey();
        this.accessorInfo = this.tokenStore.getOAuthAccessor(tokenKey);
        OAuthAccessor accessor = this.accessorInfo.getAccessor();
        if (this.origClientState.containsKey(REQ_TOKEN_KEY)) {
            accessor.requestToken = this.origClientState.get(REQ_TOKEN_KEY);
            accessor.tokenSecret = this.origClientState.get(REQ_TOKEN_SECRET_KEY);
        } else if (this.origClientState.containsKey(ACCESS_TOKEN_KEY)) {
            accessor.accessToken = this.origClientState.get(ACCESS_TOKEN_KEY);
            accessor.tokenSecret = this.origClientState.get(ACCESS_TOKEN_SECRET_KEY);
        }
    }

    private OAuthStore.TokenKey buildTokenKey() {
        OAuthStore.TokenKey tokenKey = new OAuthStore.TokenKey();
        tokenKey.setGadgetUri(this.authToken.getAppUrl());
        tokenKey.setModuleId(this.authToken.getModuleId());
        tokenKey.setServiceName(this.serviceName);
        tokenKey.setTokenName(this.tokenName);
        tokenKey.setUserId(this.authToken.getOwnerId());
        return tokenKey;
    }

    @Override
    public RemoteContent fetch(RemoteContentRequest request) throws GadgetException {
        this.realRequest = request;
        if (this.needApproval()) {
            this.checkCanApprove();
            this.fetchRequestToken();
            this.buildClientApprovalState();
            this.buildAznUrl();
            return null;
        }
        if (this.needAccessToken()) {
            this.checkCanApprove();
            this.exchangeRequestToken();
            this.saveAccessToken();
            this.buildClientAccessState();
        }
        return this.fetchData();
    }

    private boolean needApproval() {
        return this.accessorInfo.getAccessor().requestToken == null && this.accessorInfo.getAccessor().accessToken == null;
    }

    private void checkCanApprove() throws GadgetException {
        String pageOwner = this.authToken.getOwnerId();
        String pageViewer = this.authToken.getViewerId();
        String stateOwner = this.origClientState.get(OWNER_KEY);
        if (!pageOwner.equals(pageViewer)) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Only page owners can grant OAuth approval");
        }
        if (stateOwner != null && !stateOwner.equals(pageOwner)) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Client state belongs to a different person.");
        }
    }

    private void fetchRequestToken() throws GadgetException {
        try {
            OAuthAccessor accessor = this.accessorInfo.getAccessor();
            String url = accessor.consumer.serviceProvider.requestTokenURL;
            OAuthMessage request = this.newRequestMessage(url);
            OAuthMessage reply = this.sendOAuthMessage(request);
            reply.requireParameters(new String[]{"oauth_token", "oauth_token_secret"});
            accessor.requestToken = reply.getParameter("oauth_token");
            accessor.tokenSecret = reply.getParameter("oauth_token_secret");
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private OAuthMessage newRequestMessage(String method, String url, List<OAuth.Parameter> params) throws Exception {
        if (params == null) {
            throw new IllegalArgumentException("params was null in newRequestMessage(String, String, List<OAuth.Parameter> Use newRequesMessage(String) if you don't have a params to pass");
        }
        switch (this.accessorInfo.signatureType) {
            case RSA_SHA1: {
                params.add(new OAuth.Parameter("oauth_signature_method", "RSA-SHA1"));
                break;
            }
            case PLAINTEXT: {
                params.add(new OAuth.Parameter("oauth_signature_method", "PLAINTEXT"));
                break;
            }
            default: {
                params.add(new OAuth.Parameter("oauth_signature_method", "HMAC-SHA1"));
            }
        }
        OAuthAccessor accessor = this.accessorInfo.getAccessor();
        return accessor.newRequestMessage(method, url, params);
    }

    private OAuthMessage newRequestMessage(String url) throws Exception {
        ArrayList<OAuth.Parameter> params = new ArrayList<OAuth.Parameter>();
        return this.newRequestMessage(url, params);
    }

    private OAuthMessage newRequestMessage(String url, List<OAuth.Parameter> params) throws Exception {
        String method = "POST";
        if (this.accessorInfo.getHttpMethod() == OAuthStore.HttpMethod.GET) {
            method = "GET";
        }
        return this.newRequestMessage(method, url, params);
    }

    private String getAuthorizationHeader(List<Map.Entry<String, String>> oauthParams) {
        StringBuilder result = new StringBuilder("OAuth ");
        boolean first = true;
        for (Map.Entry<String, String> parameter : oauthParams) {
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            result.append(OAuth.percentEncode((String)parameter.getKey())).append("=\"").append(OAuth.percentEncode((String)parameter.getValue())).append('\"');
        }
        return result.toString();
    }

    private RemoteContentRequest createRemoteContentRequest(List<Map.Entry<String, String>> oauthParams, String method, String url, Map<String, List<String>> headers, String contentType, String postBody, RemoteContentRequest.Options options) throws IOException, URISyntaxException, GadgetException {
        OAuthStore.OAuthParamLocation paramLocation = this.accessorInfo.getParamLocation();
        HashMap<String, List<String>> newHeaders = new HashMap<String, List<String>>();
        switch (paramLocation) {
            case AUTH_HEADER: {
                if (headers != null) {
                    newHeaders.putAll(headers);
                }
                ArrayList<String> authHeader = new ArrayList<String>();
                authHeader.add(this.getAuthorizationHeader(oauthParams));
                newHeaders.put("Authorization", authHeader);
                break;
            }
            case POST_BODY: {
                if (!OAuth.isFormEncoded((String)contentType)) {
                    throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "OAuth param location can only be post_body if post body if of type x-www-form-urlencoded");
                }
                if (postBody == null || postBody.length() == 0) {
                    postBody = OAuth.formEncode(oauthParams);
                    break;
                }
                postBody = postBody + "&" + OAuth.formEncode(oauthParams);
                break;
            }
            case URI_QUERY: {
                url = OAuth.addParameters((String)url, oauthParams);
            }
        }
        byte[] postBodyBytes = postBody == null ? null : postBody.getBytes("UTF-8");
        return new RemoteContentRequest(method, new URI(url), newHeaders, postBodyBytes, options);
    }

    private OAuthMessage sendOAuthMessage(OAuthMessage request) throws IOException, URISyntaxException, GadgetException {
        RemoteContentRequest rcr = this.createRemoteContentRequest(this.filterOAuthParams(request), request.method, request.URL, null, "application/x-www-form-urlencoded; charset=utf-8", null, RemoteContentRequest.DEFAULT_OPTIONS);
        RemoteContent content = this.nextFetcher.fetch(rcr);
        OAuthMessage reply = new OAuthMessage(null, null, null);
        reply.addParameters((Collection)OAuth.decodeForm((String)content.getResponseAsString()));
        return reply;
    }

    private void buildClientApprovalState() throws GadgetException {
        try {
            OAuthAccessor accessor = this.accessorInfo.getAccessor();
            HashMap<String, String> oauthState = new HashMap<String, String>();
            oauthState.put(REQ_TOKEN_KEY, accessor.requestToken);
            oauthState.put(REQ_TOKEN_SECRET_KEY, accessor.tokenSecret);
            oauthState.put(OWNER_KEY, this.authToken.getOwnerId());
            this.newClientState = this.oauthCrypter.wrap(oauthState);
        }
        catch (BlobCrypterException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private void buildAznUrl() {
        OAuthAccessor accessor = this.accessorInfo.getAccessor();
        StringBuffer azn = new StringBuffer(accessor.consumer.serviceProvider.userAuthorizationURL);
        if (azn.indexOf("?") == -1) {
            azn.append("?");
        } else {
            azn.append("&");
        }
        azn.append("oauth_token");
        azn.append("=");
        azn.append(OAuth.percentEncode((String)accessor.requestToken));
        this.aznUrl = azn.toString();
    }

    private boolean needAccessToken() {
        return this.accessorInfo.getAccessor().requestToken != null && this.accessorInfo.getAccessor().accessToken == null;
    }

    private void exchangeRequestToken() throws GadgetException {
        try {
            OAuthAccessor accessor = this.accessorInfo.getAccessor();
            String url = accessor.consumer.serviceProvider.accessTokenURL;
            ArrayList<OAuth.Parameter> msgParams = new ArrayList<OAuth.Parameter>();
            msgParams.add(new OAuth.Parameter("oauth_token", accessor.requestToken));
            OAuthMessage request = this.newRequestMessage(url, msgParams);
            OAuthMessage reply = this.sendOAuthMessage(request);
            reply.requireParameters(new String[]{"oauth_token", "oauth_token_secret"});
            accessor.accessToken = reply.getParameter("oauth_token");
            accessor.tokenSecret = reply.getParameter("oauth_token_secret");
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private void saveAccessToken() throws GadgetException {
        OAuthAccessor accessor = this.accessorInfo.getAccessor();
        OAuthStore.TokenKey tokenKey = this.buildTokenKey();
        OAuthStore.TokenInfo tokenInfo = new OAuthStore.TokenInfo(accessor.accessToken, accessor.tokenSecret);
        this.tokenStore.storeTokenKeyAndSecret(tokenKey, tokenInfo);
    }

    private void buildClientAccessState() throws GadgetException {
        try {
            HashMap<String, String> oauthState = new HashMap<String, String>();
            OAuthAccessor accessor = this.accessorInfo.getAccessor();
            oauthState.put(ACCESS_TOKEN_KEY, accessor.accessToken);
            oauthState.put(ACCESS_TOKEN_SECRET_KEY, accessor.tokenSecret);
            oauthState.put(OWNER_KEY, this.authToken.getOwnerId());
            this.newClientState = this.oauthCrypter.wrap(oauthState);
        }
        catch (BlobCrypterException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private RemoteContent fetchData() throws GadgetException {
        try {
            ArrayList<OAuth.Parameter> msgParams = OAuth.isFormEncoded((String)this.realRequest.getContentType()) ? OAuth.decodeForm((String)this.realRequest.getPostBodyAsString()) : new ArrayList();
            String method = this.realRequest.getMethod();
            OAuthMessage oauthRequest = this.newRequestMessage(method, this.realRequest.getUri().toASCIIString(), msgParams);
            RemoteContent content = this.nextFetcher.fetch(this.createRemoteContentRequest(this.filterOAuthParams(oauthRequest), this.realRequest.getMethod(), this.realRequest.getUri().toASCIIString(), this.realRequest.getAllHeaders(), this.realRequest.getContentType(), this.realRequest.getPostBodyAsString(), this.realRequest.getOptions()));
            if (this.newClientState != null) {
                content.getMetadata().put(CLIENT_STATE, this.newClientState);
            }
            if (this.aznUrl != null) {
                content.getMetadata().put(APPROVAL_URL, this.aznUrl);
            }
            return content;
        }
        catch (UnsupportedEncodingException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private List<Map.Entry<String, String>> filterOAuthParams(OAuthMessage message) throws IOException {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry param : message.getParameters()) {
            if (!((String)param.getKey()).toLowerCase().startsWith("oauth") && !((String)param.getKey()).toLowerCase().startsWith("xoauth")) continue;
            result.add(param);
        }
        return result;
    }
}

