/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.gadgets.ContentFetcher;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetToken;
import org.apache.shindig.gadgets.oauth.BasicGadgetOAuthTokenStore;
import org.apache.shindig.gadgets.oauth.BasicOAuthStore;
import org.apache.shindig.gadgets.oauth.GadgetOAuthTokenStore;
import org.apache.shindig.gadgets.oauth.OAuthFetcher;
import org.apache.shindig.gadgets.oauth.OAuthRequestParams;
import org.apache.shindig.util.BasicBlobCrypter;
import org.apache.shindig.util.BlobCrypter;
import org.apache.shindig.util.Crypto;

public class OAuthFetcherFactory {
    protected BlobCrypter oauthCrypter;
    protected GadgetOAuthTokenStore tokenStore;
    private static final Logger logger = Logger.getLogger(OAuthFetcherFactory.class.getName());

    @Inject
    public OAuthFetcherFactory(@OAuthConfigFetcher ContentFetcher fetcher) {
        try {
            this.oauthCrypter = new BasicBlobCrypter(Crypto.getRandomBytes(16));
            BasicGadgetOAuthTokenStore basicStore = new BasicGadgetOAuthTokenStore(new BasicOAuthStore());
            basicStore.initFromConfigFile(fetcher);
            this.tokenStore = basicStore;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to initialize OAuth", t);
        }
    }

    protected OAuthFetcherFactory(BlobCrypter oauthCrypter, GadgetOAuthTokenStore tokenStore) {
        this.oauthCrypter = oauthCrypter;
        this.tokenStore = tokenStore;
    }

    public OAuthFetcher getOAuthFetcher(ContentFetcher nextFetcher, GadgetToken token, OAuthRequestParams params) throws GadgetException {
        OAuthFetcher fetcher = new OAuthFetcher(this.tokenStore, this.oauthCrypter, nextFetcher, token, params);
        fetcher.init();
        return fetcher;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    @BindingAnnotation
    public static @interface OAuthConfigFetcher {
    }
}

