/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import net.oauth.OAuthAccessor;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.gadgets.oauth.OAuthNoDataException;
import org.apache.shindig.gadgets.oauth.OAuthStoreException;

public interface OAuthStore {
    public void setOAuthServiceProviderInfo(ProviderKey var1, ProviderInfo var2) throws OAuthStoreException;

    public ProviderInfo getOAuthServiceProviderInfo(ProviderKey var1) throws OAuthStoreException, OAuthNoDataException;

    public void setOAuthConsumerKeyAndSecret(ProviderKey var1, ConsumerKeyAndSecret var2) throws OAuthStoreException, OAuthNoDataException;

    public void setTokenAndSecret(TokenKey var1, TokenInfo var2) throws OAuthStoreException;

    public AccessorInfo getOAuthAccessor(TokenKey var1) throws OAuthNoDataException, OAuthStoreException;

    public static class TokenInfo {
        private String accessToken;
        private String tokenSecret;

        public TokenInfo(String token, String secret) {
            this.accessToken = token;
            this.tokenSecret = secret;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getTokenSecret() {
            return this.tokenSecret;
        }
    }

    public static class TokenKey {
        private String userId;
        private String gadgetUri;
        private long moduleId;
        private String tokenName;
        private String serviceName;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getGadgetUri() {
            return this.gadgetUri;
        }

        public void setGadgetUri(String gadgetUri) {
            this.gadgetUri = gadgetUri;
        }

        public long getModuleId() {
            return this.moduleId;
        }

        public void setModuleId(long moduleId) {
            this.moduleId = moduleId;
        }

        public String getTokenName() {
            return this.tokenName;
        }

        public void setTokenName(String tokenName) {
            this.tokenName = tokenName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.gadgetUri == null ? 0 : this.gadgetUri.hashCode());
            result = 31 * result + (int)(this.moduleId ^ this.moduleId >>> 32);
            result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
            result = 31 * result + (this.tokenName == null ? 0 : this.tokenName.hashCode());
            result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TokenKey other = (TokenKey)obj;
            if (this.gadgetUri == null ? other.gadgetUri != null : !this.gadgetUri.equals(other.gadgetUri)) {
                return false;
            }
            if (this.moduleId != other.moduleId) {
                return false;
            }
            if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
                return false;
            }
            if (this.tokenName == null ? other.tokenName != null : !this.tokenName.equals(other.tokenName)) {
                return false;
            }
            return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
        }
    }

    public static class ProviderInfo {
        private OAuthServiceProvider provider;
        private HttpMethod httpMethod;
        private SignatureType signatureType;
        private OAuthParamLocation paramLocation;
        private ConsumerKeyAndSecret keyAndSecret;

        public OAuthParamLocation getParamLocation() {
            return this.paramLocation;
        }

        public void setParamLocation(OAuthParamLocation paramLocation) {
            this.paramLocation = paramLocation;
        }

        public ConsumerKeyAndSecret getKeyAndSecret() {
            return this.keyAndSecret;
        }

        public void setKeyAndSecret(ConsumerKeyAndSecret keyAndSecret) {
            this.keyAndSecret = keyAndSecret;
        }

        public OAuthServiceProvider getProvider() {
            return this.provider;
        }

        public void setProvider(OAuthServiceProvider provider) {
            this.provider = provider;
        }

        public HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        public void setHttpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        public SignatureType getSignatureType() {
            return this.signatureType;
        }

        public void setSignatureType(SignatureType signatureType) {
            this.signatureType = signatureType;
        }
    }

    public static class ProviderKey {
        private String gadgetUri;
        private String serviceName;

        public String getGadgetUri() {
            return this.gadgetUri;
        }

        public void setGadgetUri(String gadgetUri) {
            this.gadgetUri = gadgetUri;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.gadgetUri == null ? 0 : this.gadgetUri.hashCode());
            result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProviderKey other = (ProviderKey)obj;
            if (this.gadgetUri == null ? other.gadgetUri != null : !this.gadgetUri.equals(other.gadgetUri)) {
                return false;
            }
            return !(this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName));
        }
    }

    public static class ConsumerKeyAndSecret {
        private String consumerKey;
        private String consumerSecret;
        private KeyType keyType;

        public ConsumerKeyAndSecret(String key, String secret, KeyType type) {
            this.consumerKey = key;
            this.consumerSecret = secret;
            this.keyType = type;
        }

        public String getConsumerKey() {
            return this.consumerKey;
        }

        public String getConsumerSecret() {
            return this.consumerSecret;
        }

        public KeyType getKeyType() {
            return this.keyType;
        }
    }

    public static class AccessorInfo {
        OAuthAccessor accessor;
        HttpMethod httpMethod;
        SignatureType signatureType;
        OAuthParamLocation paramLocation;

        public OAuthParamLocation getParamLocation() {
            return this.paramLocation;
        }

        public void setParamLocation(OAuthParamLocation paramLocation) {
            this.paramLocation = paramLocation;
        }

        public OAuthAccessor getAccessor() {
            return this.accessor;
        }

        public void setAccessor(OAuthAccessor accessor) {
            this.accessor = accessor;
        }

        public HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        public void setHttpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        public SignatureType getSignatureType() {
            return this.signatureType;
        }

        public void setSignatureType(SignatureType signatureType) {
            this.signatureType = signatureType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OAuthParamLocation {
        AUTH_HEADER,
        POST_BODY,
        URI_QUERY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyType {
        HMAC_SYMMETRIC,
        RSA_PRIVATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SignatureType {
        HMAC_SHA1,
        RSA_SHA1,
        PLAINTEXT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpMethod {
        GET,
        POST;

    }
}

