/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.gadgets.Substitutions;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.util.HashUtil;
import org.apache.shindig.util.XmlException;
import org.apache.shindig.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetSpec {
    public static final String DEFAULT_VIEW = "default";
    public static final Locale DEFAULT_LOCALE = new Locale("all", "ALL");
    private final URI url;
    private final String checksum;
    private ModulePrefs modulePrefs;
    private List<UserPref> userPrefs;
    private Map<String, View> views;

    public URI getUrl() {
        return this.url;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public ModulePrefs getModulePrefs() {
        return this.modulePrefs;
    }

    public List<UserPref> getUserPrefs() {
        return this.userPrefs;
    }

    public Map<String, View> getViews() {
        return this.views;
    }

    public View getView(String name) {
        return this.views.get(name);
    }

    public GadgetSpec substitute(Substitutions substituter) {
        GadgetSpec spec = new GadgetSpec(this);
        spec.modulePrefs = this.modulePrefs.substitute(substituter);
        if (this.userPrefs.size() == 0) {
            spec.userPrefs = Collections.emptyList();
        } else {
            ArrayList<UserPref> prefs = new ArrayList<UserPref>(this.userPrefs.size());
            for (UserPref pref : this.userPrefs) {
                prefs.add(pref.substitute(substituter));
            }
            spec.userPrefs = Collections.unmodifiableList(prefs);
        }
        HashMap<String, View> viewMap = new HashMap<String, View>(this.views.size());
        for (View view : this.views.values()) {
            viewMap.put(view.getName(), view.substitute(substituter));
        }
        spec.views = Collections.unmodifiableMap(viewMap);
        return spec;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Module>\n").append(this.modulePrefs).append('\n');
        for (UserPref userPref : this.userPrefs) {
            buf.append(userPref).append('\n');
        }
        for (Map.Entry entry : this.views.entrySet()) {
            buf.append(entry.getValue()).append('\n');
        }
        buf.append("</Module>");
        return buf.toString();
    }

    public GadgetSpec(URI url, String xml) throws SpecParserException {
        Element doc;
        try {
            doc = XmlUtil.parse(xml);
        }
        catch (XmlException e) {
            throw new SpecParserException(e);
        }
        this.url = url;
        this.checksum = HashUtil.checksum(xml.getBytes());
        NodeList children = doc.getChildNodes();
        ModulePrefs modulePrefs = null;
        LinkedList<UserPref> userPrefs = new LinkedList<UserPref>();
        HashMap<String, LinkedList<Element>> views = new HashMap<String, LinkedList<Element>>();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            String name = element.getTagName();
            if ("ModulePrefs".equals(name)) {
                if (modulePrefs == null) {
                    modulePrefs = new ModulePrefs(element, url);
                } else {
                    throw new SpecParserException("Only 1 ModulePrefs is allowed.");
                }
            }
            if ("UserPref".equals(name)) {
                UserPref pref = new UserPref(element);
                userPrefs.add(pref);
            }
            if (!"Content".equals(name)) continue;
            String viewNames = XmlUtil.getAttribute(element, "view", DEFAULT_VIEW);
            for (String view : viewNames.split(",")) {
                LinkedList<Element> viewElements = (LinkedList<Element>)views.get(view = view.trim());
                if (viewElements == null) {
                    viewElements = new LinkedList<Element>();
                    views.put(view, viewElements);
                }
                viewElements.add(element);
            }
        }
        if (modulePrefs == null) {
            throw new SpecParserException("At least 1 ModulePrefs is required.");
        }
        this.modulePrefs = modulePrefs;
        if (views.size() == 0) {
            throw new SpecParserException("At least 1 Content is required.");
        }
        HashMap<String, View> tmpViews = new HashMap<String, View>();
        for (Map.Entry view : views.entrySet()) {
            View v = new View((String)view.getKey(), (List)view.getValue());
            tmpViews.put(v.getName(), v);
        }
        this.views = Collections.unmodifiableMap(tmpViews);
        this.userPrefs = userPrefs.size() > 0 ? Collections.unmodifiableList(userPrefs) : Collections.emptyList();
    }

    private GadgetSpec(GadgetSpec spec) {
        this.url = spec.url;
        this.checksum = spec.checksum;
    }
}

