/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.gadgets.Substitutions;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.util.XmlUtil;
import org.w3c.dom.Element;

public class Icon {
    private final String mode;
    private final String type;
    private String content;

    public String getMode() {
        return this.mode;
    }

    public String getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public Icon substitute(Substitutions substituter) {
        Icon icon = new Icon(this);
        icon.content = substituter.substituteString(Substitutions.Type.MESSAGE, this.content);
        return icon;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Icon type=\"").append(this.type).append("\" mode=\"").append(this.mode).append("\">").append(this.content).append("</Icon>");
        return buf.toString();
    }

    public Icon(Element element) throws SpecParserException {
        this.mode = XmlUtil.getAttribute(element, "mode");
        if (this.mode != null && !this.mode.equals("base64")) {
            throw new SpecParserException("The only valid value for Icon@mode is \"base64\"");
        }
        this.type = XmlUtil.getAttribute(element, "type", "");
        this.content = element.getTextContent();
    }

    private Icon(Icon icon) {
        this.mode = icon.mode;
        this.type = icon.type;
    }
}

