/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.util.XmlUtil;
import org.w3c.dom.Element;

public class LocaleSpec {
    private final String language;
    private final String country;
    private final String languageDirection;
    private final URI messages;

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguageDirection() {
        return this.languageDirection;
    }

    public URI getMessages() {
        return this.messages;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Locale lang=\"").append(this.language).append("\" country=\"").append(this.country).append("\" language_direction=\"").append(this.languageDirection).append("\" messages=\"").append(this.messages).append("\"/>");
        return buf.toString();
    }

    public LocaleSpec(Element element, URI specUrl) throws SpecParserException {
        this.language = XmlUtil.getAttribute(element, "lang", "all").toLowerCase();
        this.country = XmlUtil.getAttribute(element, "country", "ALL").toUpperCase();
        this.languageDirection = XmlUtil.getAttribute(element, "language_direction", "ltr");
        if (!"ltr".equals(this.languageDirection) && !"rtl".equals(this.languageDirection)) {
            throw new SpecParserException("Locale@language_direction must be ltr or rtl");
        }
        String messages = XmlUtil.getAttribute(element, "messages");
        if (messages == null) {
            this.messages = URI.create("");
        } else {
            try {
                this.messages = new URL(specUrl.toURL(), messages).toURI();
            }
            catch (URISyntaxException e) {
                throw new SpecParserException("Locale@messages url is invalid.");
            }
            catch (MalformedURLException e) {
                throw new SpecParserException("Locale@messages url is invalid.");
            }
        }
    }
}

