/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.util.XmlException;
import org.apache.shindig.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBundle {
    public static final MessageBundle EMPTY = new MessageBundle();
    private final Map<String, String> messages;

    public Map<String, String> getMessages() {
        return this.messages;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<messagebundle>\n");
        for (Map.Entry<String, String> entry : this.messages.entrySet()) {
            buf.append("<msg name=\"").append(entry.getKey()).append("\">").append(entry.getValue()).append("</msg>\n");
        }
        buf.append("</messagebundle>");
        return buf.toString();
    }

    public MessageBundle(String xml) throws SpecParserException {
        Element doc;
        try {
            doc = XmlUtil.parse(xml);
        }
        catch (XmlException e) {
            throw new SpecParserException(e);
        }
        NodeList nodes = doc.getElementsByTagName("msg");
        HashMap<String, String> messages = new HashMap<String, String>(nodes.getLength(), 1.0f);
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            Element msg = (Element)nodes.item(i);
            String name = XmlUtil.getAttribute(msg, "name");
            if (name == null) {
                throw new SpecParserException("All message bundle entries must have a name attribute.");
            }
            messages.put(name, msg.getTextContent().trim());
        }
        this.messages = Collections.unmodifiableMap(messages);
    }

    private MessageBundle() {
        this.messages = Collections.emptyMap();
    }
}

