/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.gadgets.Substitutions;
import org.apache.shindig.gadgets.spec.ElementVisitor;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.FeatureVisitor;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.Icon;
import org.apache.shindig.gadgets.spec.IconVisitor;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.LocaleVisitor;
import org.apache.shindig.gadgets.spec.Preload;
import org.apache.shindig.gadgets.spec.PreloadVisitor;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulePrefs {
    private String title;
    private URI titleUrl;
    private String description;
    private String author;
    private String authorEmail;
    private URI screenshot;
    private URI thumbnail;
    private String directoryTitle;
    private String authorAffiliation;
    private String authorLocation;
    private String authorPhoto;
    private String authorAboutme;
    private String authorQuote;
    private String authorLink;
    private boolean showStats;
    private boolean showInDirectory;
    private boolean singleton;
    private boolean scaling;
    private boolean scrolling;
    private final int width;
    private final int height;
    private final List<String> categories;
    private final Map<String, Feature> features;
    private final List<Preload> preloads;
    private List<Icon> icons;
    private final Map<Locale, LocaleSpec> locales;

    public String getTitle() {
        return this.title;
    }

    public URI getTitleUrl() {
        return this.titleUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public URI getScreenshot() {
        return this.screenshot;
    }

    public URI getThumbnail() {
        return this.thumbnail;
    }

    public String getDirectoryTitle() {
        return this.directoryTitle;
    }

    public String getAuthorAffiliation() {
        return this.authorAffiliation;
    }

    public String getAuthorLocation() {
        return this.authorLocation;
    }

    public String getAuthorPhoto() {
        return this.authorPhoto;
    }

    public String getAuthorAboutme() {
        return this.authorAboutme;
    }

    public String getAuthorQuote() {
        return this.authorQuote;
    }

    public String getAuthorLink() {
        return this.authorLink;
    }

    public boolean getShowStats() {
        return this.showStats;
    }

    public boolean getShowInDirectory() {
        return this.showInDirectory;
    }

    public boolean getSingleton() {
        return this.singleton;
    }

    public boolean getScaling() {
        return this.scaling;
    }

    public boolean getScrolling() {
        return this.scrolling;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public List<Preload> getPreloads() {
        return this.preloads;
    }

    public List<Icon> getIcons() {
        return this.icons;
    }

    public Map<Locale, LocaleSpec> getLocales() {
        return this.locales;
    }

    public LocaleSpec getLocale(Locale locale) {
        if (this.locales.size() == 0) {
            return null;
        }
        LocaleSpec localeSpec = this.locales.get(locale);
        if (localeSpec == null && (localeSpec = this.locales.get(locale = new Locale(locale.getLanguage(), "ALL"))) == null) {
            localeSpec = this.locales.get(GadgetSpec.DEFAULT_LOCALE);
        }
        return localeSpec;
    }

    public ModulePrefs substitute(Substitutions substituter) {
        ModulePrefs prefs = new ModulePrefs(this);
        if (this.icons.size() == 0) {
            prefs.icons = Collections.emptyList();
        } else {
            ArrayList<Icon> iconList = new ArrayList<Icon>(this.icons.size());
            for (Icon icon : this.icons) {
                iconList.add(icon.substitute(substituter));
            }
            prefs.icons = Collections.unmodifiableList(iconList);
        }
        Substitutions.Type type = Substitutions.Type.MESSAGE;
        prefs.author = substituter.substituteString(type, this.author);
        prefs.authorEmail = substituter.substituteString(type, this.authorEmail);
        prefs.description = substituter.substituteString(type, this.description);
        prefs.directoryTitle = substituter.substituteString(type, this.directoryTitle);
        prefs.screenshot = substituter.substituteUri(type, this.screenshot);
        prefs.thumbnail = substituter.substituteUri(type, this.thumbnail);
        prefs.title = substituter.substituteString(null, this.title);
        prefs.titleUrl = substituter.substituteUri(null, this.titleUrl);
        return prefs;
    }

    private static void walk(Element element, Map<String, ElementVisitor> visitors) throws SpecParserException {
        NodeList children = element.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            ElementVisitor visitor = visitors.get(child.getNodeName());
            if (visitor == null) continue;
            visitor.visit((Element)child);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<ModulePrefs").append(" title=\"").append(this.title).append('\"').append(" author=\"").append(this.author).append('\"').append(" author_email=\"").append(this.authorEmail).append('\"').append(" author_affiliation=\"").append(this.authorAffiliation).append('\"').append(" author_location=\"").append(this.authorLocation).append('\"').append(" author_photo=\"").append(this.authorPhoto).append('\"').append(" author_aboutme=\"").append(this.authorAboutme).append('\"').append(" author_quote=\"").append(this.authorQuote).append('\"').append(" author_link=\"").append(this.authorLink).append('\"').append(" description=\"").append(this.description).append('\"').append(" directory_title=\"").append(this.directoryTitle).append('\"').append(" screenshot=\"").append(this.screenshot).append('\"').append(" thumbnail=\"").append(this.thumbnail).append('\"').append(" height=\"").append(this.height).append('\"').append(" width=\"").append(this.width).append('\"').append(" category=\"").append(this.categories.get(0)).append('\"').append(" category2=\"").append(this.categories.get(1)).append('\"').append(" show_stats=\"").append(this.showStats).append('\"').append(" show_in_directory=\"").append(this.showInDirectory).append('\"').append(" singleton=\"").append(this.singleton).append('\"').append(" scaling=\"").append(this.scaling).append('\"').append(" scrolling=\"").append(this.scrolling).append('\"').append(">\n");
        for (Preload preload : this.preloads) {
            buf.append(preload).append("\n");
        }
        for (Feature feature : this.features.values()) {
            buf.append(feature).append('\n');
        }
        for (Icon icon : this.icons) {
            buf.append(icon).append('\n');
        }
        for (LocaleSpec locale : this.locales.values()) {
            buf.append(locale).append('\n');
        }
        buf.append("</ModulePrefs>");
        return buf.toString();
    }

    public ModulePrefs(Element element, URI specUrl) throws SpecParserException {
        this.title = XmlUtil.getAttribute(element, "title");
        if (this.title == null) {
            throw new SpecParserException("ModulePrefs@title is required.");
        }
        URI emptyUri = URI.create("");
        this.titleUrl = XmlUtil.getUriAttribute(element, "title_url", emptyUri);
        this.author = XmlUtil.getAttribute(element, "author", "");
        this.authorEmail = XmlUtil.getAttribute(element, "author_email", "");
        this.authorAffiliation = XmlUtil.getAttribute(element, "author_affiliation", "");
        this.authorLocation = XmlUtil.getAttribute(element, "author_location", "");
        this.authorPhoto = XmlUtil.getAttribute(element, "author_photo", "");
        this.authorAboutme = XmlUtil.getAttribute(element, "author_aboutme", "");
        this.authorQuote = XmlUtil.getAttribute(element, "author_quote", "");
        this.authorLink = XmlUtil.getAttribute(element, "author_link", "");
        this.description = XmlUtil.getAttribute(element, "description", "");
        this.directoryTitle = XmlUtil.getAttribute(element, "directory_title", "");
        this.screenshot = XmlUtil.getUriAttribute(element, "screenshot", emptyUri);
        this.thumbnail = XmlUtil.getUriAttribute(element, "thumbnail", emptyUri);
        this.showStats = XmlUtil.getBoolAttribute(element, "show_stats");
        this.showInDirectory = XmlUtil.getBoolAttribute(element, "show_in_directory");
        this.singleton = XmlUtil.getBoolAttribute(element, "singleton");
        this.scaling = XmlUtil.getBoolAttribute(element, "scaling");
        this.scrolling = XmlUtil.getBoolAttribute(element, "scrolling");
        String height = XmlUtil.getAttribute(element, "height");
        this.height = height == null ? 0 : Integer.parseInt(height);
        String width = XmlUtil.getAttribute(element, "width");
        this.width = width == null ? 0 : Integer.parseInt(width);
        this.categories = Arrays.asList(XmlUtil.getAttribute(element, "category", ""), XmlUtil.getAttribute(element, "category2", ""));
        PreloadVisitor preloadVisitor = new PreloadVisitor();
        FeatureVisitor featureVisitor = new FeatureVisitor();
        IconVisitor iconVisitor = new IconVisitor();
        LocaleVisitor localeVisitor = new LocaleVisitor(specUrl);
        HashMap<String, ElementVisitor> visitors = new HashMap<String, ElementVisitor>(5, 1.0f);
        visitors.put("Preload", preloadVisitor);
        visitors.put("Optional", featureVisitor);
        visitors.put("Require", featureVisitor);
        visitors.put("Icon", iconVisitor);
        visitors.put("Locale", localeVisitor);
        ModulePrefs.walk(element, visitors);
        this.preloads = Collections.unmodifiableList(preloadVisitor.preloads);
        this.features = Collections.unmodifiableMap(featureVisitor.features);
        this.icons = Collections.unmodifiableList(iconVisitor.icons);
        this.locales = Collections.unmodifiableMap(localeVisitor.locales);
    }

    private ModulePrefs(ModulePrefs prefs) {
        this.categories = prefs.getCategories();
        this.preloads = prefs.getPreloads();
        this.features = prefs.getFeatures();
        this.locales = prefs.getLocales();
        this.height = prefs.getHeight();
        this.width = prefs.getWidth();
    }
}

