/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.net.URI;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.spec.Auth;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.util.XmlUtil;
import org.w3c.dom.Element;

public class Preload {
    public static final String AUTHZ_ATTR = "authz";
    private final URI href;
    private final Auth auth;

    public URI getHref() {
        return this.href;
    }

    public Auth getAuth() {
        return this.auth;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Preload href=\"").append(this.href).append("\" authz=\"").append(this.auth.toString().toLowerCase()).append("\"/>");
        return buf.toString();
    }

    public Preload(Element preload) throws SpecParserException {
        this.href = XmlUtil.getUriAttribute(preload, "href");
        if (this.href == null) {
            throw new SpecParserException("Preload@href is required.");
        }
        String authAttr = XmlUtil.getAttribute(preload, AUTHZ_ATTR);
        try {
            this.auth = Auth.parse(authAttr);
        }
        catch (GadgetException ge) {
            throw new SpecParserException("Preload@" + ge.getMessage());
        }
    }
}

