/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.gadgets.Substitutions;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPref {
    private String name;
    private String displayName;
    private String defaultValue;
    private final boolean required;
    private final DataType dataType;
    private Map<String, String> enumValues;

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean getRequired() {
        return this.required;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Map<String, String> getEnumValues() {
        return this.enumValues;
    }

    public UserPref substitute(Substitutions substituter) {
        UserPref pref = new UserPref(this);
        Substitutions.Type type = Substitutions.Type.MESSAGE;
        pref.displayName = substituter.substituteString(type, this.displayName);
        pref.defaultValue = substituter.substituteString(type, this.defaultValue);
        if (this.enumValues.size() == 0) {
            pref.enumValues = Collections.emptyMap();
        } else {
            HashMap<String, String> values = new HashMap<String, String>(this.enumValues.size());
            for (Map.Entry<String, String> entry : this.enumValues.entrySet()) {
                values.put(entry.getKey(), substituter.substituteString(type, entry.getValue()));
            }
            pref.enumValues = Collections.unmodifiableMap(values);
        }
        return pref;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<UserPref name=\"").append(this.name).append("\" display_name=\"").append(this.displayName).append("\" default_value=\"").append(this.defaultValue).append("\" required=\"").append(this.required).append("\" datatype=\"").append(this.dataType.toString().toLowerCase()).append('\"');
        if (this.enumValues.size() == 0) {
            buf.append("/>");
        } else {
            buf.append('\n');
            for (Map.Entry<String, String> entry : this.enumValues.entrySet()) {
                buf.append("<EnumValue value=\"").append(entry.getKey()).append("\" value=\"").append("\" display_value=\"").append(entry.getValue()).append("\"/>\n");
            }
            buf.append("</UserPref>");
        }
        return buf.toString();
    }

    public UserPref(Element element) throws SpecParserException {
        String name = XmlUtil.getAttribute(element, "name");
        if (name == null) {
            throw new SpecParserException("UserPref@name is required.");
        }
        this.name = name;
        this.displayName = XmlUtil.getAttribute(element, "display_name", name);
        this.defaultValue = XmlUtil.getAttribute(element, "default_value", "");
        this.required = XmlUtil.getBoolAttribute(element, "required");
        String dataType = XmlUtil.getAttribute(element, "datatype", "string");
        this.dataType = DataType.parse(dataType);
        NodeList children = element.getElementsByTagName("EnumValue");
        if (children.getLength() > 0) {
            HashMap<String, String> enumValues = new HashMap<String, String>();
            int j = children.getLength();
            for (int i = 0; i < j; ++i) {
                Element child = (Element)children.item(i);
                String value = XmlUtil.getAttribute(child, "value");
                if (value == null) {
                    throw new SpecParserException("EnumValue@value is required.");
                }
                String displayValue = XmlUtil.getAttribute(child, "display_value", value);
                enumValues.put(value, displayValue);
            }
            this.enumValues = Collections.unmodifiableMap(enumValues);
        } else {
            this.enumValues = Collections.emptyMap();
        }
    }

    private UserPref(UserPref userPref) {
        this.name = userPref.name;
        this.dataType = userPref.dataType;
        this.required = userPref.required;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        STRING,
        HIDDEN,
        BOOL,
        ENUM,
        LIST,
        NUMBER;


        public static DataType parse(String value) {
            for (DataType type : DataType.values()) {
                if (type.toString().compareToIgnoreCase(value) != 0) continue;
                return type;
            }
            return STRING;
        }
    }
}

