/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.net.URI;
import java.util.List;
import org.apache.shindig.gadgets.Substitutions;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.util.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View {
    private final String name;
    private final ContentType type;
    private URI href;
    private final boolean quirks;
    private String content;
    private final boolean needsUserPrefSubstitution;

    public String getName() {
        return this.name;
    }

    public ContentType getType() {
        return this.type;
    }

    public URI getHref() {
        return this.href;
    }

    public boolean getQuirks() {
        return this.quirks;
    }

    public String getContent() {
        return this.content;
    }

    public boolean needsUserPrefSubstitution() {
        return this.needsUserPrefSubstitution;
    }

    public View substitute(Substitutions substituter) {
        View view = new View(this);
        view.content = substituter.substituteString(null, this.content);
        view.href = substituter.substituteUri(null, this.href);
        return view;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Content type=\"").append(this.type.toString().toLowerCase()).append("\" href=\"").append(this.href).append("\" view=\"").append(this.name).append("\">").append(this.content).append("</Content>");
        return buf.toString();
    }

    public View(String name, List<Element> elements) throws SpecParserException {
        this.name = name;
        boolean quirks = true;
        URI href = null;
        ContentType type = null;
        StringBuilder content = new StringBuilder();
        for (Element element : elements) {
            String contentType = XmlUtil.getAttribute(element, "type");
            if (contentType != null) {
                ContentType newType = ContentType.parse(contentType);
                if (type != null && newType != type) {
                    throw new SpecParserException("You may not mix content types in the same view.");
                }
                type = newType;
            }
            href = XmlUtil.getUriAttribute(element, "href", href);
            quirks = XmlUtil.getBoolAttribute(element, "quirks", quirks);
            content.append(element.getTextContent());
        }
        this.content = content.toString();
        this.needsUserPrefSubstitution = this.content.indexOf("__UP_") != -1;
        this.quirks = quirks;
        this.href = href;
        this.type = type;
        if (type == ContentType.URL && this.href == null) {
            throw new SpecParserException("Content@href must be set when Content@type is \"url\".");
        }
        if (type == ContentType.HTML && this.href != null) {
            throw new SpecParserException("Content@href must not be set when Content@type is not \"url\".");
        }
    }

    private View(View view) {
        this.needsUserPrefSubstitution = view.needsUserPrefSubstitution;
        this.name = view.name;
        this.type = view.type;
        this.quirks = view.quirks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        HTML,
        URL;


        public static ContentType parse(String value) {
            return "url".equals(value) ? URL : HTML;
        }
    }
}

